/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.request;

import com.mashape.unirest.http.HttpMethod;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.exceptions.BlufinClientException;
import org.blufin.base.exceptions.BlufinNotImplementedException;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.base.helper.IdSet;
import org.blufin.base.helper.Pair;
import org.blufin.jackson.Jackson;
import org.blufin.sdk.base.AbstractField;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.AbstractSort;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.embedded.base.EmbeddedResourceData;
import org.blufin.sdk.enums.SortOrder;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterContainer;
import org.blufin.sdk.filters.FilterUriBuilder;
import org.blufin.sdk.filters.Match;
import org.blufin.sdk.filters.SortUriBuilder;
import org.blufin.sdk.request.RequestBase;
import org.blufin.sdk.request.credentials.RequestCredentials;
import org.blufin.sdk.request.interfaces.ApiGetExecutor;
import org.blufin.sdk.response.ApiResponse;
import org.blufin.sdk.response.HttpStatus;
import org.blufin.sdk.rest.GetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
import org.json.JSONException;

public abstract class GetRequestBase<DTO extends PersistentDto, FIELD extends AbstractField, SORT extends AbstractSort>
extends RequestBase<DTO>
implements ApiGetExecutor<DTO, FIELD> {
    private AbstractMetaData metaData;
    private IdSet idSet;
    private List<Filter> filterList = new LinkedList<Filter>();
    private FilterContainer filterContainer;
    private List<Pair<String, SortOrder>> sort;
    private int page;
    private int entries;

    public GetRequestBase(ApiCredentials apiCredentials, String endPoint, Class<DTO> responseDto, AbstractMetaData metaData, RequestCredentials requestCredentials) {
        super(apiCredentials, endPoint, responseDto, requestCredentials, HttpMethod.GET);
        this.metaData = metaData;
    }

    @Override
    public ApiResponse<DTO> execute() {
        try {
            if (this.filterContainer == null) {
                this.filterContainer = new FilterContainer(Match.ALL, this.filterList);
            }
            GetRequest getRequest = new GetRequest(this.metaData, this.idSet);
            if (this.getApiCredentials().getApiCredentialsType().equals((Object)ApiCredentials.ApiCredentialsType.INTERNAL)) {
                if (this.idSet == null) {
                    if (this.filterList.size() > 0) {
                        getRequest.setFilters(this.filterContainer);
                    }
                    if (this.sort != null) {
                        getRequest.setSort(this.sort);
                    }
                    if (this.page > 0) {
                        getRequest.setPage(this.page);
                    }
                    if (this.entries > 0) {
                        getRequest.setEntries(this.entries);
                    }
                } else if (this.sort != null) {
                    getRequest.setSort(this.sort);
                }
                return this.mapIfEmbedded(this.getApiCredentials().getResourceData().executeGet(this.getEndPoint(), getRequest));
            }
            String uri = this.getApiCredentials().getApiUri() + "/" + this.getEndPoint();
            HttpResponse httpResponse = Unirest.get((String)uri).headers(this.buildHeaders()).asJson();
            JsonNode jsonNode = (JsonNode)httpResponse.getBody();
            ApiResponse apiResponse = new ApiResponse(HttpStatus.getFromCode((Integer)jsonNode.getObject().get("responseCode")));
            try {
                apiResponse.setBody((List)Jackson.getObjectMapper().readValue(jsonNode.getObject().get("data").toString(), List.class));
            }
            catch (JSONException e) {
                apiResponse.setBody(Collections.EMPTY_LIST);
            }
            return this.mapIfEmbedded(apiResponse);
        }
        catch (UnirestException | IOException | BlufinClientException | BlufinServerException e) {
            return new ApiResponse(HttpStatus.BAD_REQUEST);
        }
    }

    @Override
    public ApiResponse<Map<FIELD, Object>> executeWithLimitedFields(FIELD ... fields) {
        throw new BlufinNotImplementedException();
    }

    protected void setSortInternal(Pair<SORT, SortOrder> sort) {
        if (sort.getKey() == null || sort.getValue() == null) {
            throw new BlufinAlertDeveloperException("Field and/or SortOrder cannot be null.");
        }
        this.setSortInternal(Arrays.asList(sort));
    }

    protected void setSortInternal(List<Pair<SORT, SortOrder>> sortList) {
        ArrayList<Pair<String, SortOrder>> list = new ArrayList<Pair<String, SortOrder>>();
        sortList.forEach(pair -> list.add(Pair.of((Object)((AbstractSort)pair.getKey()).getFieldName(), (Object)pair.getValue())));
        this.sort = list;
    }

    protected void setPageInternal(int page) {
        if (page < 1) {
            throw new BlufinAlertDeveloperException("Page cannot be less than 1.");
        }
        this.page = page;
    }

    protected void setEntriesInternal(int entries) {
        if (entries < 1) {
            throw new BlufinAlertDeveloperException("Entries cannot be less than 1.");
        }
        if (entries > 100) {
            throw new BlufinAlertDeveloperException(MessageFormat.format("Exceeded maximum entries of: {0}", 100));
        }
        this.entries = entries;
    }

    protected String buildUriParameterString() {
        String uriParameterString;
        StringBuilder sb = new StringBuilder();
        if (this.entries > 0) {
            sb.append("entries").append("=").append(this.entries).append("&");
        }
        if (this.filterList != null && this.filterList.size() > 0) {
            sb.append(FilterUriBuilder.build(this.filterList)).append("&");
        }
        if (this.page > 0) {
            sb.append("page").append("=").append(this.page).append("&");
        }
        if (this.sort != null) {
            sb.append(SortUriBuilder.build(this.sort)).append("&");
        }
        if ((uriParameterString = sb.toString()).length() > 0 && uriParameterString.charAt(uriParameterString.length() - 1) == '&') {
            uriParameterString = uriParameterString.substring(0, uriParameterString.length() - 1);
        }
        return uriParameterString;
    }

    public ApiResponse<DTO> mapIfEmbedded(ApiResponse apiResponse) {
        if (!apiResponse.getBody().get(0).getClass().getName().equals(this.getResponseDto().getName())) {
            ArrayList newData = new ArrayList();
            apiResponse.getBody().forEach(source -> {
                try {
                    newData.add(EmbeddedResourceData.getInstance().mapper(this.getResponseDto().getSimpleName()).map(apiResponse.getBody().get(0)));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new BlufinAlertDeveloperException(MessageFormat.format("Embedded mapping failed: ({0}) {1}", e.getClass().getSimpleName(), e.getMessage()), (Exception)e);
                }
            });
            apiResponse.setBody(newData);
        }
        return apiResponse;
    }

    protected String getEndPointForTesting() {
        StringBuilder sb = new StringBuilder(this.getEndPoint());
        String uriParameterString = this.buildUriParameterString();
        if (uriParameterString != null && uriParameterString.length() > 0) {
            sb.append("?").append(uriParameterString);
        }
        return sb.toString();
    }

    protected String getEndPointForTesting(List<FIELD> fields) {
        throw new BlufinNotImplementedException();
    }

    protected void setMetaData(AbstractMetaData metaData) {
        this.metaData = metaData;
    }

    protected void setIdSet(IdSet idSet) {
        this.idSet = idSet;
    }

    protected List<Filter> getFilterList() {
        return this.filterList;
    }
}

