/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.request;

import java.lang.reflect.Constructor;
import java.util.List;
import org.blufin.base.exceptions.BlufinNotImplementedException;
import org.blufin.base.helper.Pair;
import org.blufin.sdk.base.AbstractField;
import org.blufin.sdk.base.AbstractMapperEmbedded;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.AbstractSort;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.enums.SortOrder;
import org.blufin.sdk.filters.FilterContainer;
import org.blufin.sdk.request.GetRequestBase;
import org.blufin.sdk.request.credentials.RequestCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;

public class PaginatedGetRequest<DTO extends PersistentDto, FIELD extends AbstractField, SORT extends AbstractSort, REFINER extends Refiner>
extends GetRequestBase<DTO, FIELD, SORT> {
    protected final Class<REFINER> refiner;
    protected final AbstractMapperEmbedded embeddedMapped = null;
    protected Constructor<?> refinerImplCache;

    public PaginatedGetRequest(ApiCredentials apiCredentials, String endPoint, Class<DTO> responseDto, AbstractMetaData metaData, Class<REFINER> refiner) {
        super(apiCredentials, endPoint, responseDto, metaData, null);
        this.refiner = refiner;
    }

    public PaginatedGetRequest(ApiCredentials apiCredentials, String endPoint, Class<DTO> responseDto, AbstractMetaData metaData, Class<REFINER> refiner, RequestCredentials requestCredentials) {
        super(apiCredentials, endPoint, responseDto, metaData, requestCredentials);
        this.refiner = refiner;
    }

    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> page(int page) {
        this.setPageInternal(page);
        return this;
    }

    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> entries(int entries) {
        this.setEntriesInternal(entries);
        return this;
    }

    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> sortBy(SORT sortableField) {
        this.setSortInternal(Pair.of(sortableField, (Object)((Object)SortOrder.ASC)));
        return this;
    }

    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> sortBy(SORT sortableField, SortOrder sortOrder) {
        this.setSortInternal(Pair.of(sortableField, (Object)((Object)sortOrder)));
        return this;
    }

    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> sortBy(List<Pair<SORT, SortOrder>> sortList) {
        this.setSortInternal(sortList);
        return this;
    }

    public REFINER where() {
        try {
            return (REFINER)((Refiner)this.getRefiner().newInstance(this.getFilterList(), this));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> where(FilterContainer filterContainer) {
        throw new BlufinNotImplementedException();
    }

    protected Constructor<?> getRefiner() {
        try {
            if (this.refinerImplCache == null) {
                this.refinerImplCache = Class.forName(this.refiner.getName()).getConstructor(List.class, PaginatedGetRequest.class);
            }
            return this.refinerImplCache;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

