/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.request;

import com.mashape.unirest.http.HttpMethod;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.enums.AuthHeader;
import org.blufin.sdk.request.credentials.RequestCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;

public abstract class RequestBase<DTO extends PersistentDto> {
    private final ApiCredentials apiCredentials;
    private final String endPoint;
    private final Class<DTO> responseDto;
    private final HttpMethod httpMethod;
    private RequestCredentials requestCredentials;

    public RequestBase(ApiCredentials apiCredentials, String endPoint, Class<DTO> responseDto, RequestCredentials requestCredentials, HttpMethod httpMethod) {
        this.endPoint = endPoint;
        this.responseDto = responseDto;
        this.apiCredentials = apiCredentials;
        this.requestCredentials = requestCredentials;
        this.httpMethod = httpMethod;
    }

    protected Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        switch (this.apiCredentials.getApiCredentialsType()) {
            case INTERNAL: {
                throw new RuntimeException("When using a ResourceLocator to make API requests internally the code should never hit here.");
            }
            case HTTP: {
                headers.put(AuthHeader.AUTH_INTERNAL.toString(), this.apiCredentials.getAuthorizationHeader());
                if (this.requestCredentials == null) break;
                if (this.requestCredentials.getAccountUser() > -1) {
                    headers.put(AuthHeader.AUTH_ACCOUNT_USER.toString(), String.valueOf(this.requestCredentials.getAccountUser()));
                }
                if (this.requestCredentials.getAccountName() == null) break;
                headers.put(AuthHeader.AUTH_ACCOUNT_NAME.toString(), this.requestCredentials.getAccountName());
                break;
            }
            case HTTP_OAUTH: {
                headers.put(AuthHeader.X_OAUTH_DEV.toString(), this.apiCredentials.getDeveloperKey());
                headers.put(AuthHeader.X_OAUTH_APP.toString(), this.apiCredentials.getApplicationKey());
                if (this.requestCredentials == null) break;
                if (this.requestCredentials.getAccountUser() > 0) {
                    headers.put(AuthHeader.X_OAUTH_ACCOUNT_USER.toString(), String.valueOf(this.requestCredentials.getAccountUser()));
                }
                if (this.requestCredentials.getAccountToken() == null) break;
                headers.put(AuthHeader.X_OAUTH_ACCOUNT_TOKEN.toString(), this.requestCredentials.getAccountToken());
                break;
            }
            default: {
                throw new RuntimeException(MessageFormat.format("Unrecognized ApiCredentialsType: {0}", this.apiCredentials.getApiCredentialsType().toString()));
            }
        }
        return headers;
    }

    protected ApiCredentials getApiCredentials() {
        return this.apiCredentials;
    }

    protected String getEndPoint() {
        return this.endPoint;
    }

    protected Class<DTO> getResponseDto() {
        return this.responseDto;
    }

    protected HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    protected RequestCredentials getRequestCredentials() {
        return this.requestCredentials;
    }
}

