/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.request.type;

import java.text.MessageFormat;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.enums.RequestType;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.request.credentials.RequestCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;

public abstract class AbstractRequest<T> {
    protected final ApiCredentials apiCredentials;
    protected final String endPoint;
    protected final Class<? extends PersistentDto> responseDto;
    protected final AbstractMetaData metaData;
    protected final RequestType requestType;
    protected Class<? extends Refiner> refiner;
    protected IdSet idSet;

    public AbstractRequest(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, Class<? extends Refiner> refiner) {
        this.apiCredentials = apiCredentials;
        this.endPoint = endPoint;
        this.responseDto = responseDto;
        this.metaData = metaData;
        this.refiner = refiner;
        this.requestType = RequestType.PAGINATED;
    }

    public AbstractRequest(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, IdSet idSet) {
        this.apiCredentials = apiCredentials;
        this.endPoint = endPoint;
        this.responseDto = responseDto;
        this.metaData = metaData;
        this.idSet = idSet;
        this.requestType = RequestType.IDSET;
    }

    protected T requestObject(RequestCredentials requestCredentials) {
        switch (this.requestType) {
            case PAGINATED: {
                return (T)new PaginatedGetRequest(this.apiCredentials, this.endPoint, this.responseDto, this.metaData, this.refiner, requestCredentials);
            }
            case IDSET: {
                return (T)new IdSetGetRequest(this.apiCredentials, this.endPoint, this.responseDto, this.metaData, this.idSet, requestCredentials);
            }
        }
        throw new RuntimeException(MessageFormat.format("Unrecognized RequestType: {0}", this.requestType.toString()));
    }
}

