/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.response;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.response.AckWarning;

public class AckResolver {
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();

    public void addError(AckError error, String ... args) {
        this.errors.add(error.name() + " - " + MessageFormat.format(error.getMessage(), args));
    }

    public void addWarning(AckWarning warning, String ... args) {
        this.warnings.add(warning.name() + " - " + MessageFormat.format(warning.getMessage(), args));
    }

    public boolean contains(AckError error) {
        for (int i = 0; i < this.errors.size(); ++i) {
            if (!this.errors.get(i).startsWith(error.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(AckWarning warning) {
        for (int i = 0; i < this.warnings.size(); ++i) {
            if (!this.warnings.get(i).startsWith(warning.toString())) continue;
            return true;
        }
        return false;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

