/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.response;

import java.text.MessageFormat;

public enum AckWarning {
    BOOLEAN_NOT_LOWERCASE(Type.CLIENT, "Boolean value provided for ''{2}'' is expected to be lowercase. Value: {0} was interpreted as \u2192 {1}"),
    BYTE_CONTAINED_LEADING_ZEROS(Type.CLIENT, "Value provided for ''{2}'' contained unnecessary leading zero(s). Value: {0} was interpreted as \u2192 {1}"),
    DATE_UNCONVENTIONAL_FORMAT(Type.CLIENT, "Date value provided for ''{2}'' is in an unconventional format. This resource expected: yyyy-MM-dd. Value {0} was interpreted as \u2192 {1}"),
    DATETIME_UNCONVENTIONAL_FORMAT(Type.CLIENT, "Datetime value provided for ''{2}'' is in an unconventional format. This resource expected: yyyy-MM-ddTHH:mm:ss. Value {0} was interpreted as \u2192 {1}"),
    DECIMAL_CONTAINED_LEADING_ZEROS(Type.CLIENT, "A decimal value provided for ''{2}'' contained unnecessary leading zero(s). Value: {0} was interpreted as \u2192 {1}"),
    DECIMAL_CONTAINED_TRAILING_ZEROS(Type.CLIENT, "Value provided for ''{2}'' contained unnecessary trailing zero(s). This resource expected: DECIMAL({3},{4}). Value: {0} was interpreted as \u2192 {1}"),
    FIELD_NAME_CONTAINED_UNNECESSARY_WHITESPACE(Type.CLIENT, "Table/field nam(e) for ''{2}'' contained unnecessary leading/trailing whitespace. Value: ''{0}'' was interpreted as \u2192 ''{1}''"),
    FIELD_NAME_NOT_LOWERCASE(Type.CLIENT, "Table/field name(s) for ''{2}'' are expected to be all lowercase. Value: {0} was interpreted as \u2192 {1}"),
    FILTER_DATE_REVERSED(Type.CLIENT, "Date values provided for ''{3}'' are in reverse order. 1st date is larger than the 2nd date in a filter pair. Values were interpreted as \u2192 {0} {1} {2}"),
    FILTER_DATETIME_REVERSED(Type.CLIENT, "Datetime values provided for ''{3}'' are in reverse order. 1st date is larger than the 2nd date in a filter pair. Values were interpreted as \u2192 {0} {1} {2}"),
    FILTER_VALUES_REVERSED(Type.CLIENT, "Values provided for ''{3}'' are in reverse order. 1st value is larger than the 2nd value in a filter pair. Values were interpreted as \u2192 {0} {1} {2}"),
    FILTER_TOO_MANY_PARAMETERS(Type.CLIENT, "Received too many parameters for ''{1}'' filter, expected {2} but got {3}. The following parameters were ignored -> {0}"),
    INT_CONTAINED_LEADING_ZEROS(Type.CLIENT, "Value provided for ''{2}'' contained unnecessary leading zero(s). Value: {0} was interpreted as \u2192 {1}"),
    JSON_TYPE_MISMATCH(Type.CLIENT, "''{0}'' expected data-type of: {1} , instead got: {2}. Value was interpreted as \u2192 ({1}) {3}"),
    LONG_CONTAINED_LEADING_ZEROS(Type.CLIENT, "Value provided for ''{2}'' contained unnecessary leading zero(s). Value: {0} was interpreted as \u2192 {1}"),
    NOTHING_TO_DELETE(Type.CLIENT, "Unable to delete ''{1}'' with ID: {0}{2} because it doesn''t exist."),
    ID_MISSING_BUT_INFERRED(Type.CLIENT, "''{1}'' was missing, NULL or invalid but our system was able to infer it as: {0}."),
    SHORT_CONTAINED_LEADING_ZEROS(Type.CLIENT, "Value provided for ''{2}'' contained unnecessary leading zero(s). Value: {0} was interpreted as \u2192 {1}"),
    SORT_ORDER_MISSING(Type.CLIENT, "Sort order for ''{1}'' is missing. The following default was applied \u2192 ''{0}''"),
    SORT_ORDER_BLANK(Type.CLIENT, "Sort order for ''{1}'' is {2}. The following default was applied \u2192 ''{0}''"),
    SORT_ORDER_NOT_LOWERCASE(Type.CLIENT, "Sort order provided for ''{0}'' is expected to be lowercase. Value: {1} was interpreted as \u2192 {2}"),
    SORT_TOO_MANY_PARAMETERS(Type.CLIENT, "Received too many parameters for ''{1}'' sort, expected {2} but got {3}. The following parameters were ignored \u2192 {0}"),
    STRING_ENUM_NOT_UPPERCASE(Type.CLIENT, "Enum value provided for ''{2}'' contained lowercase character(s). This resource expected all uppercase characters. Value: {0} was interpreted as \u2192 {1}"),
    TRANSIENT_PROPERTY_IGNORED(Type.CLIENT, "Value for ''{0}'' will be ignored because this is a transient property that should never be sent back to server{1}.");

    private final Type type;
    private final String message;

    private AckWarning(Type type, String message) {
        this.type = type;
        this.message = message;
    }

    public String toString(String ... args) {
        return this.name() + " - " + MessageFormat.format(this.message, args);
    }

    public Type getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    private static enum Type {
        CLIENT,
        SERVER;

    }
}

