/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.response;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import org.blufin.base.exceptions.BlufinClientException;
import org.blufin.base.exceptions.BlufinNotFoundException;
import org.blufin.base.exceptions.BlufinNotImplementedException;
import org.blufin.base.utils.UtilsEnvironment;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.base.utils.UtilsStackTrace;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.response.ApiResponse;
import org.blufin.sdk.response.HttpStatus;

public class ApiResponseBuilder {
    public static ApiResponse badRequest(BlufinClientException e) {
        ApiResponse apiResponse = new ApiResponse(HttpStatus.BAD_REQUEST);
        if (e.getErrors().size() > 0) {
            e.getErrors().sort(String::compareToIgnoreCase);
            apiResponse.setErrors(e.getErrors());
        }
        if (e.getWarnings().size() > 0) {
            e.getWarnings().sort(String::compareToIgnoreCase);
            apiResponse.setWarnings(e.getWarnings());
        }
        if (e.getFormattedStackTrace() != null) {
            apiResponse.setStackTrace(e.getFormattedStackTrace());
        }
        return apiResponse;
    }

    @Deprecated
    public static ApiResponse badRequest(AckError error, String ... args) {
        ApiResponse apiResponse = new ApiResponse(HttpStatus.BAD_REQUEST);
        apiResponse.setErrors(Arrays.asList(error.toString(args)));
        return apiResponse;
    }

    public static ApiResponse unauthorized() {
        ApiResponse apiResponse = new ApiResponse(HttpStatus.UNAUTHORIZED);
        apiResponse.setErrors(Arrays.asList(AckError.UNAUTHORIZED.toString()));
        return apiResponse;
    }

    public static ApiResponse forbidden() {
        ApiResponse apiResponse = new ApiResponse(HttpStatus.FORBIDDEN);
        apiResponse.setErrors(Arrays.asList(AckError.FORBIDDEN.toString()));
        return apiResponse;
    }

    public static ApiResponse notFound(BlufinNotFoundException e) {
        if (Integer.parseInt(e.getHttpStatus()) != HttpStatus.NOT_FOUND.getCode()) {
            UtilsLogger.alertDeveloper((String)MessageFormat.format("HTTP Status: {0} did not match expected: {1}", e.getHttpStatus(), HttpStatus.NOT_FOUND.getCode()));
        }
        ApiResponse apiResponse = new ApiResponse(HttpStatus.NOT_FOUND);
        apiResponse.setErrors(Arrays.asList(AckError.RESOURCE_NOT_FOUND.toString(e.getHttpUri())));
        return apiResponse;
    }

    public static ApiResponse serverError(Throwable t) {
        ApiResponse apiResponse = new ApiResponse(HttpStatus.INTERNAL_SERVER_ERROR);
        if ((UtilsEnvironment.isLocal() || UtilsEnvironment.isDevelopment()) && t != null) {
            String message = ApiResponseBuilder.getExceptionMessage(t);
            apiResponse.setErrors(Arrays.asList(t.getClass().getSimpleName() + (message != null ? ": " + message : "")));
            apiResponse.setStackTrace(UtilsStackTrace.buildOutput((StackTraceElement[])t.getStackTrace()));
        } else {
            apiResponse.setErrors(Arrays.asList("Our server(s) encountered a problem they were not able to handle."));
        }
        return apiResponse;
    }

    public static ApiResponse notImplemented(BlufinNotImplementedException e) {
        ApiResponse apiResponse = new ApiResponse(HttpStatus.NOT_IMPLEMENTED);
        apiResponse.setStackTrace(e.getFormattedStackTrace());
        return apiResponse;
    }

    public static ApiResponse genericError(Throwable t, org.springframework.http.HttpStatus status) {
        ApiResponse apiResponse = new ApiResponse(HttpStatus.getFromCode(status.value()));
        String message = ApiResponseBuilder.getExceptionMessage(t);
        if (message != null) {
            apiResponse.setErrors(Collections.singletonList(message));
        }
        return apiResponse;
    }

    private static String getExceptionMessage(Throwable t) {
        return t.getMessage() != null && t.getMessage().length() > 0 ? t.getMessage() : null;
    }
}

