/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.blufin.base.helper.Pair;

public class ApiResponsePagination {
    private final int page;
    private final int pageEntries;
    private final int totalPages;
    private final int totalEntries;
    @JsonProperty
    private final boolean hasMore;

    private ApiResponsePagination(int page, int entries, int totalRows) {
        Pair<Integer, Boolean> calculationResults = this.calculate(page, entries, totalRows);
        this.page = page;
        this.pageEntries = entries;
        this.totalPages = (Integer)calculationResults.getKey();
        this.totalEntries = totalRows;
        this.hasMore = (Boolean)calculationResults.getValue();
    }

    public static ApiResponsePagination of(int page, int entries, int totalRows) {
        return new ApiResponsePagination(page, entries, totalRows);
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    private Pair<Integer, Boolean> calculate(int page, int entries, int totalRows) {
        int pageRemainder = totalRows % entries;
        int pagesTotal = totalRows / entries + (pageRemainder > 0 ? 1 : 0);
        return Pair.of((Object)pagesTotal, (Object)(page < pagesTotal ? 1 : 0));
    }

    public int getPage() {
        return this.page;
    }

    public int getPageEntries() {
        return this.pageEntries;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getTotalEntries() {
        return this.totalEntries;
    }
}

