/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.rest;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.base.helper.IdSet;
import org.blufin.base.helper.Triplet;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.AbstractValidatorInterface;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.enums.HttpMethod;
import org.blufin.sdk.enums.PayloadType;
import org.blufin.sdk.helper.IdHelper;
import org.blufin.sdk.response.AckResolver;
import org.blufin.sdk.response.AckResolverThreadLocal;
import org.blufin.sdk.rest.AbstractRequest;

public abstract class AbstractPayLoadRequest<D extends PersistentDto>
extends AbstractRequest {
    private final List<D> payload;
    private final PayloadType payloadType;
    private final IdSet modifiedIds;
    private Triplet<String, String, Integer> modifiedParentData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractPayLoadRequest(Connection connection, AbstractMetaData metaData, AbstractValidatorInterface<D> validator, List<D> payload, PayloadType payloadType) throws BlufinServerException {
        super(payloadType == PayloadType.POST ? HttpMethod.POST : HttpMethod.PUT, metaData, AckResolverThreadLocal.get());
        this.payload = payload;
        this.payloadType = payloadType;
        this.modifiedIds = new IdSet();
        if (this.ackResolver == null) {
            throw new BlufinAlertDeveloperException(MessageFormat.format("{0} should never be null within {1} constructor.", AckResolver.class.getSimpleName(), AbstractPayLoadRequest.class.getSimpleName()));
        }
        try {
            if (payload.size() <= 0) return;
            switch (payloadType) {
                case POST: {
                    validator.validatePost(connection, payload, this.ackResolver);
                    return;
                }
                case PUT: {
                    validator.validatePut(connection, payload, this.ackResolver);
                    return;
                }
                default: {
                    throw new BlufinAlertDeveloperException(MessageFormat.format("Unsupported payloadType: {0}", payloadType.toString()));
                }
            }
        }
        finally {
            AckResolverThreadLocal.destroy();
        }
    }

    public void addIdToResponse(int id) {
        this.modifiedIds.add(Integer.valueOf(id));
    }

    public void addParentDataToResponse(List<D> dtos, String table, String parentIdFieldName) {
        if (this.modifiedParentData != null) {
            throw new BlufinAlertDeveloperException(MessageFormat.format("{0}.addParentIdToResponse() was called when ''modifiedParentData'' already had a value: {1}. This property was designed in a way to only ever expects a single Pair of values.", this.getClass().getSimpleName(), this.modifiedParentData.toString()));
        }
        Integer parentId = IdHelper.extractParentId(dtos);
        if (!IdHelper.isValid(parentId)) {
            throw new BlufinAlertDeveloperException(MessageFormat.format("Parent ID was ''{1}'' in {0}.addParentIdToResponse().", this.getClass().getSimpleName(), parentId));
        }
        this.modifiedParentData = Triplet.of((Object)table, (Object)parentIdFieldName, (Object)parentId);
    }

    public List<D> getPayload() {
        return this.payload;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public IdSet getModifiedIds() {
        return this.modifiedIds;
    }

    public Triplet<String, String, Integer> getModifiedParentData() {
        return this.modifiedParentData;
    }
}

