/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.rest;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.blufin.base.helper.IdSet;
import org.blufin.base.helper.Pair;
import org.blufin.base.utils.UtilsUrl;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.enums.HttpMethod;
import org.blufin.sdk.enums.SortOrder;
import org.blufin.sdk.filters.FilterContainer;
import org.blufin.sdk.normalization.DataNormalizationException;
import org.blufin.sdk.normalization.DataNormalizer;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.rest.AbstractRequest;
import org.blufin.sdk.validators.FieldValidator;
import org.blufin.sdk.validators.FilterValidator;
import org.blufin.sdk.validators.SortValidator;

public class GetRequest
extends AbstractRequest {
    private final IdSet idSet;
    private List<String> fields;
    private FilterContainer filters;
    private List<Pair<String, SortOrder>> sort;
    private int page = 1;
    private int entries = 50;

    public GetRequest(AbstractMetaData metaData) {
        super(HttpMethod.GET, metaData);
        this.idSet = null;
    }

    public GetRequest(AbstractMetaData metaData, IdSet idSet) {
        super(HttpMethod.GET, metaData);
        this.idSet = idSet;
    }

    public void setFields(String queryParameter) {
        if (queryParameter != null) {
            try {
                this.setFields(FieldValidator.deserialize(UtilsUrl.decode((String)queryParameter), this.ackResolver, this.metaData));
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                this.ackResolver.addError(AckError.URL_ENCODING_ERROR, queryParameter, "filters");
            }
        }
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setFilters(String queryParameters) {
        if (queryParameters != null) {
            try {
                this.setFilters(FilterValidator.deserialize(UtilsUrl.decode((String)queryParameters), this.ackResolver, this.metaData));
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                this.ackResolver.addError(AckError.URL_ENCODING_ERROR, queryParameters, "filters");
            }
        }
    }

    public void setFilters(FilterContainer filters) {
        this.filters = filters;
    }

    public void setSort(String queryParameters) {
        if (queryParameters != null) {
            try {
                this.setSort(SortValidator.deserialize(UtilsUrl.decode((String)queryParameters), this.ackResolver, this.metaData));
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                this.ackResolver.addError(AckError.URL_ENCODING_ERROR, queryParameters, "sort");
            }
        }
    }

    public void setSort(List<Pair<String, SortOrder>> sortList) {
        this.sort = sortList;
    }

    public void setPage(String page) {
        if (page != null) {
            try {
                this.setPage(DataNormalizer.normalizeInt(UtilsUrl.decode((String)page), "page", this.ackResolver));
            }
            catch (DataNormalizationException dataNormalizationException) {
            }
            catch (IllegalArgumentException e) {
                this.ackResolver.addError(AckError.URL_ENCODING_ERROR, page, "page");
            }
            catch (UnsupportedEncodingException e) {
                this.ackResolver.addError(AckError.URL_ENCODING_ERROR, page, "page");
            }
        }
    }

    public void setPage(int page) {
        if (page < 1) {
            this.ackResolver.addError(AckError.PAGE_UNDER_MINIMUM, String.valueOf(page));
        } else {
            this.page = page;
        }
    }

    public void setEntries(String entries) {
        if (entries != null) {
            try {
                this.setEntries(DataNormalizer.normalizeInt(UtilsUrl.decode((String)entries), "entries", this.ackResolver));
            }
            catch (DataNormalizationException dataNormalizationException) {
            }
            catch (IllegalArgumentException e) {
                this.ackResolver.addError(AckError.URL_ENCODING_ERROR, entries, "entries");
            }
            catch (UnsupportedEncodingException e) {
                this.ackResolver.addError(AckError.URL_ENCODING_ERROR, entries, "entries");
            }
        }
    }

    public void setEntries(int entries) {
        if (entries < 1) {
            this.ackResolver.addError(AckError.ENTRIES_UNDER_MINIMUM, String.valueOf(entries));
        } else if (entries > 100) {
            this.ackResolver.addError(AckError.ENTRIES_EXCEEDED_MAXIMUM, String.valueOf(entries));
        } else {
            this.entries = entries;
        }
    }

    public String getTableName() {
        return this.metaData.getTable();
    }

    public List<String> getTableFields() {
        return this.metaData.getAllFields();
    }

    public List<String> getTableHierarchy() {
        return this.metaData.getTableHierarchy();
    }

    public IdSet getIdSet() {
        return this.idSet;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public FilterContainer getFilters() {
        return this.filters;
    }

    public List<Pair<String, SortOrder>> getSort() {
        return this.sort;
    }

    public int getPage() {
        return this.page;
    }

    public int getEntries() {
        return this.entries;
    }
}

