/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import java.io.IOException;
import java.text.MessageFormat;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.blufin.sdk.base.ResourceData;
import org.blufin.sdk.service.credentials.ApiCredentials;

public abstract class BlufinApiService {
    private boolean initialized = false;
    private ResourceData resourceData;
    private ApiCredentials apiCredentials;

    public abstract void initialize(ResourceData var1);

    public abstract void initialize(String var1, String var2);

    protected void initializeParent(ApiCredentials apiCredentials) {
        if (this.notInitialized()) {
            this.apiCredentials = apiCredentials;
        }
    }

    private boolean notInitialized() {
        if (this.initialized) {
            throw new RuntimeException(MessageFormat.format("Cannot initialize class twice: {0}", this.getClass().getSimpleName()));
        }
        this.initialized = true;
        return true;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected ResourceData getResourceData() {
        return this.resourceData;
    }

    protected ApiCredentials getApiCredentials() {
        return this.apiCredentials;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected void setResourceData(ResourceData resourceData) {
        this.resourceData = resourceData;
    }

    protected void setApiCredentials(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }

    static {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){
            private ObjectMapper objectMapper = new ObjectMapper();

            public <T> T readValue(String body, Class<T> clazz) {
                try {
                    return (T)this.objectMapper.readValue(body, clazz);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object object) {
                try {
                    return this.objectMapper.writeValueAsString(object);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (s, sslSession) -> true);
            Unirest.setHttpClient((HttpClient)HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to configure Unirest HTTP Client with custom SSLContext.", e);
        }
    }
}

