/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.validators;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.blufin.base.helper.Pair;
import org.blufin.base.helper.Quadruplet;
import org.blufin.jackson.Jackson;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.enums.SortOrder;
import org.blufin.sdk.normalization.DataNormalizationException;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.response.AckResolver;
import org.blufin.sdk.response.AckWarning;
import org.blufin.sdk.validators.AbstractGetValidator;

public final class SortValidator
extends AbstractGetValidator {
    private static final ObjectMapper objectMapper = Jackson.getMinimalObjectMapper();
    public static final String DESERIALIZER_EXPECTED_FORMAT = "'[\"id\",\"asc\"]' OR '[[\"field-1\",\"asc\"],[\"field-2\",\"desc\"]]'";

    public static List<Pair<String, SortOrder>> deserialize(String sortString, AckResolver ackResolver, AbstractMetaData metaData) {
        if (sortString == null || sortString.trim().equals("")) {
            return null;
        }
        try {
            List<List<String>> deserializedData;
            try {
                List sortParameters = (List)objectMapper.readValue(sortString, (TypeReference)new TypeReference<List<String>>(){});
                deserializedData = Arrays.asList(sortParameters);
            }
            catch (IOException e1) {
                deserializedData = (List<List<String>>)objectMapper.readValue(sortString, (TypeReference)new TypeReference<List<List<String>>>(){});
            }
            ArrayList<Pair<String, SortOrder>> sortList = new ArrayList<Pair<String, SortOrder>>();
            SortValidator.validateDeserializedData(deserializedData, sortList, ackResolver, metaData);
            if (sortList.size() == 0) {
                return null;
            }
            return sortList;
        }
        catch (IOException | DataNormalizationException e) {
            ackResolver.addError(AckError.SORT_DESERIALIZATION_FAILURE, DESERIALIZER_EXPECTED_FORMAT, sortString);
            return null;
        }
    }

    private static void validateDeserializedData(List<List<String>> deserializedData, List<Pair<String, SortOrder>> sortList, AckResolver ackResolver, AbstractMetaData metaData) throws DataNormalizationException {
        if (deserializedData == null || deserializedData.size() == 0) {
            throw new DataNormalizationException();
        }
        for (List<String> sortParameters : deserializedData) {
            if (sortParameters == null || sortParameters.size() == 0) {
                throw new DataNormalizationException();
            }
            for (String content : sortParameters) {
                if (content != null) continue;
                throw new DataNormalizationException();
            }
            Quadruplet<String, String, String, Boolean> fieldData = SortValidator.resolveAndValidateFieldName(sortParameters.get(0), metaData.getTable(), ackResolver, metaData, AbstractGetValidator.ValidationType.SORT);
            if (fieldData == null) continue;
            String fieldNameWithTable = (String)fieldData.getThird();
            if (sortParameters.size() == 1) {
                ackResolver.addWarning(AckWarning.SORT_ORDER_MISSING, SortOrder.ASC.toString(), fieldNameWithTable);
                sortList.add((Pair<String, SortOrder>)Pair.of((Object)fieldNameWithTable, (Object)((Object)SortOrder.ASC)));
                continue;
            }
            if (sortParameters.size() == 2) {
                String sortOrderString = sortParameters.get(1);
                if (sortOrderString == null || sortOrderString.trim().equals("")) {
                    ackResolver.addWarning(AckWarning.SORT_ORDER_BLANK, SortOrder.ASC.toString(), fieldNameWithTable, "[BLANK]");
                    continue;
                }
                if (sortOrderString.equalsIgnoreCase(SortOrder.ASC.toString()) || sortOrderString.equalsIgnoreCase(SortOrder.DESC.toString())) {
                    if (!sortOrderString.equals(SortOrder.ASC.toString()) && !sortOrderString.equals(SortOrder.DESC.toString())) {
                        ackResolver.addWarning(AckWarning.SORT_ORDER_NOT_LOWERCASE, fieldNameWithTable, sortOrderString, sortOrderString.toLowerCase());
                    }
                    sortList.add((Pair<String, SortOrder>)Pair.of((Object)fieldNameWithTable, (Object)((Object)SortOrder.valueOf(sortOrderString.toUpperCase()))));
                    continue;
                }
                ackResolver.addError(AckError.SORT_ORDER_NOT_SUPPORTED, sortOrderString, fieldNameWithTable, SortOrder.ASC.toString(), SortOrder.DESC.toString());
                continue;
            }
            if (sortParameters.size() <= 2) continue;
            ArrayList<String> ignoredParameters = new ArrayList<String>();
            for (int i = 0; i < sortParameters.size(); ++i) {
                if (i < 2) continue;
                ignoredParameters.add(sortParameters.get(i));
            }
            ackResolver.addWarning(AckWarning.SORT_TOO_MANY_PARAMETERS, ((Object)ignoredParameters).toString(), fieldNameWithTable, "2", String.valueOf(sortParameters.size()));
        }
    }
}

