/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.worker.queue;

import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import org.blufin.base.exceptions.BlufinClientException;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.cloud.queue.MessageClient;
import org.blufin.core.cloud.queue.MessageDeliveryHandler;
import org.blufin.core.cloud.queue.MessageIncoming;
import org.blufin.core.utils.UtilsFile;
import org.blufin.worker.queue.MessageHandlerInterface;

public class MessageHandler {
    private final Map<String, MessageHandlerInterface> messageTypeToHandler;
    public static final DateTimeFormatter ZDT_OUTPUT_WITHOUT_ZONE = DateTimeFormatter.ofPattern("YYYY-MM-dd-HH-mm-ss-SSS");

    public MessageHandler(Map<String, MessageHandlerInterface> messageTypeToHandler) {
        this.messageTypeToHandler = messageTypeToHandler;
    }

    public void start() {
        MessageDeliveryHandler messageDeliveryHandler = messages -> {
            ArrayList<MessageIncoming> messagesToDelete = new ArrayList<MessageIncoming>();
            try {
                for (MessageIncoming message : messages) {
                    try {
                        boolean messageSuccessful = this.getHandlerFor(message.getType()).handle(message);
                        if (messageSuccessful) {
                            messagesToDelete.add(message);
                            continue;
                        }
                        UtilsLogger.alertDeveloper((String)("Failed to process " + message.getType() + " task. The raw message body (included in this error) has been deleted from the message queue and cannot be retrieved again."), (String)message.getBody());
                        messagesToDelete.add(message);
                    }
                    catch (Exception e) {
                        String failedMessage = MessageHandler.saveFailedMessage(message);
                        UtilsLogger.alertDeveloper((String)("Worker service failed to process a task from the message queue and saved to: " + failedMessage), (Throwable)e);
                    }
                }
            }
            finally {
                return messagesToDelete;
            }
        };
        MessageClient.getInstance().consume(messageDeliveryHandler);
    }

    private MessageHandlerInterface getHandlerFor(String messageType) throws BlufinClientException {
        MessageHandlerInterface messageHandler = this.messageTypeToHandler.get(messageType);
        if (messageHandler == null) {
            throw new RuntimeException(MessageFormat.format("No handler found for messageType: {0}", messageType));
        }
        return messageHandler;
    }

    private static String saveFailedMessage(MessageIncoming message) {
        String messageSavePath = "";
        String messageId = message.getId() == null ? "" : "-" + message.getId();
        try {
            messageSavePath = "/tmp/worker-service-failure-" + ZonedDateTime.now().format(ZDT_OUTPUT_WITHOUT_ZONE) + messageId + "-" + message.getIp() + ".txt";
            return messageSavePath;
        }
        finally {
            UtilsFile.writeStringToFile((String)messageSavePath, (String)message.getBody());
            return messageSavePath;
        }
    }
}

