/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.model.ProvisioningModel;
import org.bndly.common.app.provisioning.model.RunMode;
import org.bndly.common.app.provisioning.model.StartLevelBundle;
import org.bndly.common.app.provisioning.util.PlexusLoggerToMavenLoggerAdapter;
import org.bndly.common.app.provisioning.util.ProvisioningModelLoader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="bndly-application")
public class ProvisioningDependencyLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        super.afterProjectsRead(session);
        PlexusLoggerToMavenLoggerAdapter log = new PlexusLoggerToMavenLoggerAdapter(this.logger);
        List projects = session.getProjects();
        HashMap<ArtifactDefinition, MavenProject> reactorProjectsByArtifactDefinition = new HashMap<ArtifactDefinition, MavenProject>();
        for (MavenProject project : projects) {
            String gid = project.getGroupId();
            String aid = project.getArtifactId();
            String version = project.getVersion();
            ArtifactDefinition artifactDefinition = new ArtifactDefinition(gid + ":" + aid + ":" + (String)version);
            reactorProjectsByArtifactDefinition.put(artifactDefinition, project);
        }
        for (MavenProject project : projects) {
            if (!"bndly-application".equals(project.getPackaging())) continue;
            List dependencies = project.getDependencies();
            HashMap<ArtifactDefinition, Dependency> projectDependencies = new HashMap<ArtifactDefinition, Dependency>();
            for (Dependency dependency : dependencies) {
                projectDependencies.put(ArtifactDefinition.fromDependency(dependency).reduceToGroupdIdArtifactIdVersion(), dependency);
            }
            ArrayList<Dependency> dependenciesToAddFromReactor = new ArrayList<Dependency>();
            try {
                ProvisioningModel provisioningModel = new ProvisioningModelLoader(log).setProject(project).loadProvisioningModel();
                for (RunMode runMode : provisioningModel.getRunModes()) {
                    for (StartLevelBundle bundle : runMode.getBundles()) {
                        for (ArtifactDefinition artifact : bundle.getArtifacts()) {
                            ArtifactDefinition reduced = artifact.reduceToGroupdIdArtifactIdVersion();
                            MavenProject provisioningDependency = (MavenProject)reactorProjectsByArtifactDefinition.get(reduced);
                            if (provisioningDependency == null) continue;
                            if (projectDependencies.containsKey(reduced)) {
                                log.debug("skipping explicit project dependency: " + artifact);
                                continue;
                            }
                            log.debug("adding project dependency: " + artifact);
                            Dependency dep = new Dependency();
                            dep.setGroupId(artifact.getGroupId());
                            dep.setArtifactId(artifact.getArtifactId());
                            dep.setVersion(artifact.getVersion());
                            dep.setClassifier(artifact.getClassifier());
                            dep.setScope("provided");
                            dependenciesToAddFromReactor.add(dep);
                        }
                    }
                }
                dependencies.addAll(dependenciesToAddFromReactor);
            }
            catch (MojoExecutionException ex) {
                throw new MavenExecutionException(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

