/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bndly.common.json.api.ConversionContext;
import org.bndly.common.json.api.ConversionContextBuilder;
import org.bndly.common.json.model.JSArray;
import org.bndly.common.json.model.JSBoolean;
import org.bndly.common.json.model.JSMember;
import org.bndly.common.json.model.JSNull;
import org.bndly.common.json.model.JSNumber;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSString;
import org.bndly.common.json.model.JSValue;

public class Config {
    private final String name;
    private final Map<String, Object> properties;

    Config(String configName, JSObject properties) {
        Set members = properties.getMembers();
        if (members != null && !members.isEmpty()) {
            LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
            for (JSMember member : members) {
                String propertyName = member.getName().getValue();
                JSValue val = member.getValue();
                Object valJava = this.convert(val);
                tmp.put(propertyName, valJava);
            }
            this.properties = Collections.unmodifiableMap(tmp);
        } else {
            this.properties = Collections.EMPTY_MAP;
        }
        this.name = configName;
    }

    public JSValue toJsValue() {
        ConversionContext context = new ConversionContextBuilder().initDefaults().build();
        JSObject jsObject = new JSObject();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object val = entry.getValue();
            if (val == null) {
                jsObject.createMember(entry.getKey()).setValue((JSValue)JSNull.INSTANCE);
                continue;
            }
            jsObject.createMember(entry.getKey()).setValue(context.serialize(val.getClass(), val));
        }
        return jsObject;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private Object convert(JSValue val) {
        if (JSArray.class.isInstance(val)) {
            ArrayList<Object> converted = new ArrayList<Object>();
            JSArray arr = (JSArray)val;
            for (JSValue arrayItem : arr) {
                converted.add(this.convert(arrayItem));
            }
            return converted.toArray();
        }
        if (JSString.class.isInstance(val)) {
            return ((JSString)val).getValue();
        }
        if (JSNull.class.isInstance(val)) {
            return null;
        }
        if (JSNumber.class.isInstance(val)) {
            return ((JSNumber)val).getValue();
        }
        if (JSBoolean.class.isInstance(val)) {
            return ((JSBoolean)val).isValue();
        }
        throw new IllegalArgumentException("unsupported value: " + val);
    }
}

