/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.util;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.bndly.common.app.provisioning.ProvisioningModelParser;
import org.bndly.common.app.provisioning.model.ProvisioningModel;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public final class ProvisioningModelLoader {
    private final Log logger;
    private File provisioningDirectory;
    private StringSearchInterpolator stringSearchInterpolator;

    public ProvisioningModelLoader(Log logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is not allowed to be null");
        }
        this.logger = logger;
    }

    private Log getLog() {
        return this.logger;
    }

    private StringSearchInterpolator getStringSearchInterpolator() {
        return this.stringSearchInterpolator;
    }

    public final ProvisioningModelLoader setProject(MavenProject project) {
        this.setProvisioningDirectory(project.getBasedir().toPath().resolve("src/main/prov").toFile());
        this.stringSearchInterpolator = new StringSearchInterpolator();
        this.init(this.stringSearchInterpolator, project);
        return this;
    }

    private void init(StringSearchInterpolator stringSearchInterpolator, MavenProject project) {
        stringSearchInterpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(project.getProjectBuildingRequest().getSystemProperties()));
        stringSearchInterpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(project.getProjectBuildingRequest().getUserProperties()));
        stringSearchInterpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(project.getProperties()));
    }

    public final ProvisioningModelLoader setProvisioningDirectory(File provisioningDirectory) {
        this.provisioningDirectory = provisioningDirectory;
        return this;
    }

    public final ProvisioningModelLoader setStringSearchInterpolator(StringSearchInterpolator stringSearchInterpolator) {
        this.stringSearchInterpolator = stringSearchInterpolator;
        return this;
    }

    public final ProvisioningModel loadProvisioningModel() throws MojoExecutionException {
        return this.loadProvisioningModel(true);
    }

    public final ProvisioningModel loadProvisioningModel(boolean interpolatePlaceholderStrings) throws MojoExecutionException {
        File[] provisioningFiles;
        if (this.provisioningDirectory.isDirectory()) {
            provisioningFiles = this.provisioningDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".json");
                }
            });
        } else if (this.provisioningDirectory.isFile()) {
            if (!this.provisioningDirectory.getName().endsWith(".json")) {
                throw new MojoExecutionException("failed to get provisioning model from " + this.provisioningDirectory.toString() + ", because it is not a folder or json file.");
            }
            provisioningFiles = new File[]{this.provisioningDirectory};
        } else {
            throw new MojoExecutionException("failed to get provisioning model from " + this.provisioningDirectory.toString());
        }
        if (provisioningFiles == null || provisioningFiles.length == 0) {
            throw new MojoExecutionException("no provisioning file found");
        }
        this.getLog().debug((CharSequence)("Found " + provisioningFiles.length + " provisioning files"));
        ProvisioningModelParser provisioningModelParser = new ProvisioningModelParser();
        ArrayList<ProvisioningModel> models = new ArrayList<ProvisioningModel>();
        for (File provisioningFile : provisioningFiles) {
            this.getLog().debug((CharSequence)("Processing " + provisioningFile));
            try {
                ProvisioningModel model;
                if (interpolatePlaceholderStrings) {
                    StringSearchInterpolator interp = this.getStringSearchInterpolator();
                    if (interp == null) {
                        throw new MojoExecutionException("no string search interpolator configured.");
                    }
                    String provisioningJson = Files.toString((File)provisioningFile, (Charset)Charset.forName("UTF-8"));
                    model = provisioningModelParser.parse(new StringReader(provisioningJson), interp);
                } else {
                    try (BufferedReader provisioningFileReader = Files.newReader((File)provisioningFile, (Charset)Charset.forName("UTF-8"));){
                        model = provisioningModelParser.parse(provisioningFileReader, null);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Failed to parse '" + provisioningFile + "'", (Exception)e);
                    }
                }
                models.add(model);
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not parse provisioning file", (Exception)e);
            }
            catch (InterpolationException ex) {
                throw new MojoExecutionException("could not interpolate provisioning file properties", (Exception)((Object)ex));
            }
        }
        return new ProvisioningModel(models.toArray(new ProvisioningModel[models.size()]));
    }
}

