/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.model.Config;
import org.bndly.common.app.provisioning.model.ProvisioningModel;
import org.bndly.common.app.provisioning.model.ResourceDefinition;
import org.bndly.common.app.provisioning.model.RunMode;
import org.bndly.common.app.provisioning.model.StartLevelBundle;
import org.bndly.common.app.provisioning.mojo.AbstractProvisioningMojo;
import org.bndly.common.app.provisioning.mojo.PackageLayout;
import org.bndly.common.app.provisioning.util.ArtifactHelper;
import org.bndly.common.osgi.config.spi.PrefixHandler;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="prepare-package", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=false)
public class PreparePackageMojo
extends AbstractProvisioningMojo {
    private static final String SECURE_CONFIG_HINT = "@SECURE";

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.getLog().info((CharSequence)"loading provisioning model");
        ProvisioningModel model = this.loadProvisioningModel();
        this.getLog().info((CharSequence)"did load provisioning model");
        this.project.setContextValue("bndly-application:provisioning", (Object)model);
        Path targetAppFolder = this.getTargetAppFolder();
        this.unpackAppMain(model);
        this.unpackFelixFramework();
        Properties fileInfoProperties = new Properties();
        this.copyBundles(targetAppFolder, model, fileInfoProperties);
        if (this.runModeConfigurations) {
            this.createRunModeProperties(targetAppFolder, model);
        }
        PreparePackageMojo.createConfigs(targetAppFolder, model, this.getLog(), fileInfoProperties, this.runModeConfigurations);
        PreparePackageMojo.copyResources(this.getArtifactHelper(), targetAppFolder, model, fileInfoProperties);
        this.createManifest();
        if (this.saveProvisioningModel) {
            this.writeProvisioningModel(this.loadProvisioningModel(false), "provisioning-model.json");
        }
        this.writeFileInfoProperties(fileInfoProperties);
    }

    private void createManifest() throws MojoExecutionException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("bndly-Application", this.project.getArtifactId());
        attributes.putValue("Main-Class", this.getMainClassName());
        Path manifestPath = this.getManifestPath();
        this.deleteIfExists(manifestPath);
        this.createFileAndParentDirectories(manifestPath);
        try (OutputStream out = Files.newOutputStream(manifestPath, StandardOpenOption.WRITE);){
            manifest.write(out);
            out.flush();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not write manifest", (Exception)ex);
        }
    }

    static void copyResources(ArtifactHelper artifactHelper, final Path targetAppFolder, ProvisioningModel model, final Properties fileInfoProperties) throws MojoExecutionException {
        for (RunMode runMode : model.getRunModes()) {
            for (ResourceDefinition resourceDefinition : runMode.getResources()) {
                List<String> excludes;
                List<ArtifactDefinition> artifacts;
                Path targetPath;
                String target = resourceDefinition.getTarget();
                if (target == null) {
                    targetPath = targetAppFolder;
                } else {
                    if (!Paths.get(target, new String[0]).isAbsolute()) {
                        target = targetAppFolder.resolve(Paths.get(target, new String[0])).toString();
                    }
                    targetPath = Paths.get(target, new String[0]);
                }
                if (Files.notExists(targetPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                        if (fileInfoProperties != null) {
                            String key = targetAppFolder.relativize(targetPath).normalize().toString();
                            fileInfoProperties.setProperty(key, "d");
                        }
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("could not create folder " + targetPath);
                    }
                }
                if (!(artifacts = resourceDefinition.getArtifacts()).isEmpty()) {
                    for (ArtifactDefinition artifact : artifacts) {
                        Path pathToArtifact = artifactHelper.resolvePathToArtifact(artifact);
                        if (resourceDefinition.isUnpack()) {
                            try {
                                if (Files.notExists(targetPath, new LinkOption[0])) {
                                    Files.createDirectory(targetPath, new FileAttribute[0]);
                                }
                            }
                            catch (IOException ex) {
                                throw new MojoExecutionException("could not create directory for unpacked artifact " + artifact.toString(), (Exception)ex);
                            }
                            try {
                                List<String> excludes2;
                                UnArchiver unarchiver = artifactHelper.getUnArchiver(pathToArtifact.toFile());
                                unarchiver.setDestDirectory(targetPath.toFile());
                                unarchiver.setSourceFile(pathToArtifact.toFile());
                                IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
                                List<String> includes = resourceDefinition.getIncludes();
                                boolean requiresSelector = false;
                                if (includes != null && !includes.isEmpty()) {
                                    selector.setIncludes(includes.toArray(new String[includes.size()]));
                                    requiresSelector = true;
                                }
                                if ((excludes2 = resourceDefinition.getExcludes()) != null && !excludes2.isEmpty()) {
                                    selector.setExcludes(excludes2.toArray(new String[excludes2.size()]));
                                    requiresSelector = true;
                                }
                                if (requiresSelector) {
                                    unarchiver.setFileSelectors(new FileSelector[]{selector});
                                }
                                unarchiver.extract();
                                if (fileInfoProperties == null) continue;
                                Files.walkFileTree(unarchiver.getDestDirectory().toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                        String key = targetAppFolder.relativize(file.normalize()).toString();
                                        if (fileInfoProperties.getProperty(key) == null) {
                                            fileInfoProperties.setProperty(key, "r");
                                        }
                                        return FileVisitResult.CONTINUE;
                                    }

                                    @Override
                                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                                        return FileVisitResult.TERMINATE;
                                    }

                                    @Override
                                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                                continue;
                            }
                            catch (IOException | NoSuchArchiverException ex) {
                                throw new MojoExecutionException("no unarchiver for " + artifact.toString(), (Exception)ex);
                            }
                        }
                        Path targetFilePath = targetPath.resolve(pathToArtifact.getFileName());
                        try {
                            Files.deleteIfExists(targetFilePath);
                        }
                        catch (IOException ex) {
                            throw new MojoExecutionException("could not delete existing resource file at " + targetFilePath, (Exception)ex);
                        }
                        try {
                            Files.copy(pathToArtifact, targetFilePath, new CopyOption[0]);
                            if (fileInfoProperties == null) continue;
                            fileInfoProperties.setProperty(targetAppFolder.relativize(targetFilePath).toString(), "r");
                        }
                        catch (IOException ex) {
                            throw new MojoExecutionException("could not copy resource to " + targetFilePath, (Exception)ex);
                        }
                    }
                    continue;
                }
                String source = resourceDefinition.getSource();
                if (source == null) {
                    source = artifactHelper.getProjectBaseDirPath().resolve("src").resolve("main").resolve("resources").toString();
                } else if (!Paths.get(source, new String[0]).isAbsolute()) {
                    source = artifactHelper.getProjectBaseDirPath().resolve(Paths.get(source, new String[0])).toString();
                }
                Path sourcePath = Paths.get(source, new String[0]);
                DirectoryScanner directoryScanner = new DirectoryScanner();
                directoryScanner.setBasedir(source);
                List<String> includes = resourceDefinition.getIncludes();
                if (includes != null && !includes.isEmpty()) {
                    directoryScanner.setIncludes(includes.toArray(new String[includes.size()]));
                }
                if ((excludes = resourceDefinition.getExcludes()) != null && !excludes.isEmpty()) {
                    directoryScanner.setExcludes(excludes.toArray(new String[excludes.size()]));
                }
                directoryScanner.addDefaultExcludes();
                directoryScanner.scan();
                for (String includedFile : directoryScanner.getIncludedFiles()) {
                    Path tmp = Paths.get(includedFile, new String[0]);
                    Path includedFilePath = sourcePath.resolve(tmp);
                    Path targetFilePath = targetPath.resolve(tmp);
                    try {
                        Files.deleteIfExists(targetFilePath);
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("could not delete existing resource file at " + targetFilePath, (Exception)ex);
                    }
                    Path parent = targetFilePath.getParent();
                    if (Files.notExists(parent, new LinkOption[0])) {
                        try {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                        catch (IOException ex) {
                            throw new MojoExecutionException("could not create parent directory " + parent, (Exception)ex);
                        }
                    }
                    try {
                        Files.copy(includedFilePath, targetFilePath, new CopyOption[0]);
                        if (fileInfoProperties == null) continue;
                        fileInfoProperties.setProperty(targetAppFolder.relativize(targetFilePath).toString(), "r");
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("could not copy resource to " + targetFilePath, (Exception)ex);
                    }
                }
            }
        }
    }

    static void createConfigs(Path targetAppFolder, ProvisioningModel model, Log log, Properties fileInfoProperties, boolean runModeConfigurations) throws MojoExecutionException {
        ServiceLoader<PrefixHandler> loader = ServiceLoader.load(PrefixHandler.class);
        loader.reload();
        Iterator<PrefixHandler> handlers = loader.iterator();
        HashMap<String, PrefixHandler> handlersByPrefix = new HashMap<String, PrefixHandler>();
        while (handlers.hasNext()) {
            PrefixHandler next = handlers.next();
            handlersByPrefix.put(next.getPrefix(), next);
        }
        HashSet<String> configNames = new HashSet<String>();
        Path configFolderTmp = targetAppFolder.resolve("conf").resolve("app");
        for (RunMode runMode : model.getRunModes()) {
            Path configFolder = !runModeConfigurations ? configFolderTmp : configFolderTmp.resolve("runmode-" + runMode.getName());
            for (Config config : runMode.getConfigs()) {
                PrefixHandler prefixHandler;
                String configName = config.getName();
                if (configNames.contains(configName)) {
                    log.warn((CharSequence)("config " + configName + " appears multiple times"));
                }
                configNames.add(configName);
                String configHint = (String)config.getProperties().get(SECURE_CONFIG_HINT);
                if (configHint == null) {
                    configHint = "";
                }
                if ((prefixHandler = (PrefixHandler)handlersByPrefix.get(configHint)) == null && !configHint.isEmpty()) {
                    throw new MojoExecutionException("could not find config prefix handler " + configHint);
                }
                Properties properties = new Properties();
                boolean isSecured = false;
                for (Map.Entry<String, Object> entry : config.getProperties().entrySet()) {
                    String key = entry.getKey();
                    if (SECURE_CONFIG_HINT.equals(key)) {
                        isSecured = true;
                        continue;
                    }
                    Object value = entry.getValue();
                    String valueString = PreparePackageMojo.convertConfigValueToString(value);
                    String valuePlainOrEncrypted = prefixHandler == null ? valueString : "@{" + configHint + ":" + prefixHandler.set(valueString) + "}";
                    properties.setProperty(key, valuePlainOrEncrypted);
                }
                if (Files.notExists(configFolder, new LinkOption[0])) {
                    try {
                        Files.createDirectories(configFolder, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("could not create config folder", (Exception)ex);
                    }
                }
                String extension = isSecured ? ".scfg" : ".cfg";
                Path configFile = configFolder.resolve(configName + extension);
                try {
                    Files.deleteIfExists(configFile);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("could not delete existing config file", (Exception)ex);
                }
                try {
                    Files.createFile(configFile, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("could not create empty config file", (Exception)ex);
                }
                try {
                    OutputStream out = Files.newOutputStream(configFile, StandardOpenOption.WRITE);
                    try {
                        properties.store(out, null);
                        out.flush();
                        if (fileInfoProperties == null) continue;
                        fileInfoProperties.setProperty(targetAppFolder.relativize(configFile).toString(), "c");
                    }
                    finally {
                        if (out == null) continue;
                        out.close();
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("could not write config file", (Exception)ex);
                }
            }
        }
    }

    private void copyBundles(Path targetAppFolder, ProvisioningModel model, Properties fileInfoProperties) throws MojoExecutionException {
        Path bundleFolder = targetAppFolder.resolve("auto-deploy");
        List<RunMode> runModes = model.getRunModes();
        for (RunMode runMode : runModes) {
            List<StartLevelBundle> bundles = runMode.getBundles();
            for (StartLevelBundle bundle : bundles) {
                Path startLevelTargetFolder = bundleFolder.resolve(Integer.toString(bundle.getStartLevel()));
                if (Files.notExists(startLevelTargetFolder, new LinkOption[0])) {
                    try {
                        Files.createDirectories(startLevelTargetFolder, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("could not create target folder for startlevel", (Exception)ex);
                    }
                }
                List<ArtifactDefinition> artifacts = bundle.getArtifacts();
                for (ArtifactDefinition artifact : artifacts) {
                    if (this.isAppMainArtifact(artifact)) continue;
                    File file = this.resolveArtifactDefinitionToArtifactFile(artifact);
                    if (file == null) {
                        throw new MojoExecutionException("could not get artifact file " + artifact.toString());
                    }
                    Path ap = file.toPath();
                    try {
                        Path targetPathForArtifact = startLevelTargetFolder.resolve(ap.getFileName());
                        Files.deleteIfExists(targetPathForArtifact);
                        Files.copy(ap, targetPathForArtifact, new CopyOption[0]);
                        if (fileInfoProperties == null) continue;
                        fileInfoProperties.setProperty(targetAppFolder.relativize(targetPathForArtifact).toString(), "b");
                    }
                    catch (IOException ex) {
                        throw new MojoExecutionException("could not copy artifact " + artifact.toString(), (Exception)ex);
                    }
                }
            }
        }
    }

    static String convertConfigValueToString(Object value) throws MojoExecutionException {
        if (value == null) {
            return "";
        }
        if (BigDecimal.class.isInstance(value)) {
            return value.toString();
        }
        if (String.class.isInstance(value)) {
            return (String)value;
        }
        if (Boolean.class.isInstance(value)) {
            return Boolean.toString((Boolean)value);
        }
        if (value.getClass().isArray()) {
            Object[] arr = (Object[])value;
            StringBuilder sb = null;
            for (Object object : arr) {
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.append(",");
                }
                sb.append(PreparePackageMojo.convertConfigValueToString(object));
            }
            return sb == null ? "" : sb.toString();
        }
        throw new MojoExecutionException("could not convert value to config string value: " + value);
    }

    private void createRunModeProperties(Path targetAppFolder, ProvisioningModel model) throws MojoExecutionException {
        Map<Integer, Properties> runModePropertiesByStartLevel = this.extractRunModeProperties(model);
        Path bundleFolder = targetAppFolder.resolve("auto-deploy");
        for (Map.Entry<Integer, Properties> entry : runModePropertiesByStartLevel.entrySet()) {
            Integer startLevel = entry.getKey();
            Properties runmodeProperties = entry.getValue();
            Path startLevelTargetFolder = bundleFolder.resolve(Integer.toString(startLevel));
            if (Files.notExists(startLevelTargetFolder, new LinkOption[0])) {
                try {
                    Files.createDirectories(startLevelTargetFolder, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("could not create target folder for startlevel", (Exception)ex);
                }
            }
            Path runModePropertiesFilePath = startLevelTargetFolder.resolve("runmode.properties");
            try {
                Files.deleteIfExists(runModePropertiesFilePath);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not delete existing run mode properties file", (Exception)ex);
            }
            try {
                Files.createFile(runModePropertiesFilePath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not create empty run mode properties file", (Exception)ex);
            }
            try {
                BufferedWriter writer = Files.newBufferedWriter(runModePropertiesFilePath, Charset.forName("UTF-8"), StandardOpenOption.WRITE);
                try {
                    runmodeProperties.store(writer, "Generated run mode properties file.");
                    ((Writer)writer).flush();
                }
                finally {
                    if (writer == null) continue;
                    ((Writer)writer).close();
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not write to run mode properties file", (Exception)ex);
            }
        }
    }

    private void unpackFelixFramework() throws MojoExecutionException {
        Path destination;
        if (this.packageLayout == PackageLayout.war) {
            destination = this.getTargetJavaMainFolder().resolve("WEB-INF").resolve("classes");
        } else if (this.packageLayout == PackageLayout.classic) {
            destination = this.getTargetJavaMainFolder();
        } else {
            this.getLog().info((CharSequence)"skipping unpacking of Apache Felix for spring boot application layout");
            return;
        }
        this.getLog().info((CharSequence)("unpacking felix to " + destination));
        Artifact artifact = this.getFelixFrameworkArtifact();
        if (artifact == null) {
            throw new MojoExecutionException("could not load felix framework artifact");
        }
        File file = artifact.getFile();
        if (file == null) {
            throw new MojoExecutionException("artifact " + artifact.getArtifactId() + " has no file attached");
        }
        try {
            UnArchiver unArchiver = this.getArtifactHelper().getUnArchiver(file);
            this.assertUnpackDestinationFolderExists(destination);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(destination.toFile());
            IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
            includeExcludeFileSelector.setIncludes(new String[]{"**/*"});
            includeExcludeFileSelector.setExcludes(new String[]{"META-INF/MANIFEST.MF", "META-INF/maven", "META-INF/maven/*", "META-INF/maven/**/*"});
            unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("failed to unpack app main");
        }
    }

    private void unpackAppMain(ProvisioningModel model) throws MojoExecutionException {
        ArtifactDefinition appMain = this.getAppMainArtifact(model);
        if (appMain == null) {
            throw new MojoExecutionException("could not find app main artifact");
        }
        this.getLog().debug((CharSequence)("app main artifact: " + appMain.toString()));
        Artifact appMainMavenArtifact = this.getArtifactHelper().loadArtifact(appMain);
        if (appMainMavenArtifact == null) {
            throw new MojoExecutionException("could not load artifact of " + appMain.toString());
        }
        this.extractMainClasspathLibrary(appMain);
        for (String additionalMainClasspathLibrary : this.additionalMainClasspathLibraries) {
            ArtifactDefinition additionalLibrary = new ArtifactDefinition(additionalMainClasspathLibrary);
            this.getLog().info((CharSequence)("extracting additional main classpath library " + additionalMainClasspathLibrary));
            this.extractMainClasspathLibrary(additionalLibrary);
        }
    }

    private void extractMainClasspathLibrary(ArtifactDefinition artifactDefinition) throws MojoExecutionException {
        Path destination;
        if (this.packageLayout == PackageLayout.war) {
            destination = this.getTargetJavaMainFolder().resolve("WEB-INF").resolve("classes");
        } else if (this.packageLayout == PackageLayout.classic) {
            destination = this.getTargetJavaMainFolder();
        } else {
            this.getLog().info((CharSequence)"skipping unpacking of FelixMain for spring boot application layout");
            return;
        }
        Artifact additionalArtifact = this.getArtifactHelper().loadArtifact(artifactDefinition);
        if (additionalArtifact == null) {
            throw new MojoExecutionException("could not find additional artifact " + artifactDefinition);
        }
        File file = additionalArtifact.getFile();
        if (file == null) {
            throw new MojoExecutionException("artifact " + artifactDefinition.toString() + " has no file attached");
        }
        try {
            UnArchiver unArchiver = this.getArtifactHelper().getUnArchiver(file);
            this.getLog().info((CharSequence)("unpacking artifact to " + destination));
            this.assertUnpackDestinationFolderExists(destination);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(destination.toFile());
            IncludeExcludeFileSelector includeExcludeFileSelector = new IncludeExcludeFileSelector();
            includeExcludeFileSelector.setIncludes(new String[]{"**/*"});
            includeExcludeFileSelector.setExcludes(new String[]{"**/*.class", "META-INF/MANIFEST.MF", "META-INF/maven", "META-INF/maven/*", "META-INF/maven/**/*"});
            unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
            unArchiver.extract();
            if (this.packageLayout == PackageLayout.war) {
                unArchiver.setDestDirectory(destination.toFile());
                this.assertUnpackDestinationFolderExists(destination);
            }
            includeExcludeFileSelector.setIncludes(new String[]{"**/*.class"});
            includeExcludeFileSelector.setExcludes(new String[0]);
            unArchiver.setFileSelectors(new FileSelector[]{includeExcludeFileSelector});
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("failed to unpack app main", (Exception)((Object)e));
        }
    }

    private void assertUnpackDestinationFolderExists(Path destination) throws MojoExecutionException {
        if (Files.notExists(destination, new LinkOption[0])) {
            try {
                Files.createDirectories(destination, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not create output folder " + destination, (Exception)e);
            }
        }
    }

    private ArtifactDefinition dependencyToArtifactDefinition(Dependency dependency) {
        return ArtifactDefinition.fromDependency(dependency);
    }

    private Artifact getFelixFrameworkArtifact() throws MojoExecutionException {
        List dependencies = this.project.getDependencies();
        for (Dependency dependency : dependencies) {
            if (!"org.apache.felix".equals(dependency.getGroupId()) || !"org.apache.felix.framework".equals(dependency.getArtifactId())) continue;
            return this.getArtifactHelper().loadArtifact(this.dependencyToArtifactDefinition(dependency));
        }
        return this.getArtifactHelper().loadArtifact(new ArtifactDefinition("org.apache.felix:org.apache.felix.framework:jar:5.6.12"));
    }

    private boolean isAppMainArtifact(ArtifactDefinition artifact) {
        return "org.bndly.common".equals(artifact.getGroupId()) && "org.bndly.common.app-main".equals(artifact.getArtifactId());
    }

    private ArtifactDefinition getAppMainArtifact(ProvisioningModel model) {
        for (RunMode runMode : model.getRunModes()) {
            for (StartLevelBundle bundle : runMode.getBundles()) {
                for (ArtifactDefinition artifact : bundle.getArtifacts()) {
                    if (!this.isAppMainArtifact(artifact)) continue;
                    return artifact;
                }
            }
        }
        List plugins = this.project.getBuild().getPlugins();
        for (Plugin plugin : plugins) {
            if (!"org.bndly.common".equals(plugin.getGroupId()) || !"bndly-maven-plugin".equals(plugin.getArtifactId())) continue;
            List pluginDependencies = plugin.getDependencies();
            if (pluginDependencies != null) {
                for (Dependency pluginDependency : pluginDependencies) {
                    ArtifactDefinition artifact = this.dependencyToArtifactDefinition(pluginDependency);
                    if (!this.isAppMainArtifact(artifact)) continue;
                    return artifact;
                }
            }
            return new ArtifactDefinition("org.bndly.common:org.bndly.common.app-main:jar:" + plugin.getVersion());
        }
        return null;
    }

    static void recursiveDelete(Path targetFilePath) throws IOException {
        Files.walkFileTree(targetFilePath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void writeFileInfoProperties(Properties fileInfoProperties) throws MojoExecutionException {
        Path outputPath = this.packageLayout == PackageLayout.springboot ? Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("app").resolve("SBO-INF").resolve("file-info.properties") : Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("file-info.properties");
        this.deleteIfExists(outputPath);
        this.createFileAndParentDirectories(outputPath);
        try (OutputStream out = Files.newOutputStream(outputPath, StandardOpenOption.WRITE);){
            try (OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");){
                fileInfoProperties.store(w, null);
                w.flush();
            }
            out.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to render provisioning model to file '" + outputPath + "'", (Exception)e);
        }
    }
}

