/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private final int[] numerics;
    private final String suffix;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+)*)?(\\S*)");
    private static final int[] EMPTY_NUMBERS = new int[0];
    private static final String EMPTY_SUFFIX = "";

    public static Version from(String versionAsString) {
        Matcher matcher = NUMBER_PATTERN.matcher(versionAsString);
        if (matcher.matches()) {
            String suffix;
            int[] n;
            String numberPart = matcher.group(1);
            if (numberPart != null && !numberPart.isEmpty()) {
                String[] numbers = numberPart.split("\\.");
                n = new int[numbers.length];
                for (int i = 0; i < numbers.length; ++i) {
                    n[i] = Integer.valueOf(numbers[i]);
                }
            } else {
                n = EMPTY_NUMBERS;
            }
            if ((suffix = matcher.group(2)) != null && suffix.isEmpty()) {
                suffix = EMPTY_SUFFIX;
            }
            return new Version(n, suffix);
        }
        throw new IllegalArgumentException("can not process version: " + versionAsString);
    }

    private Version(int[] numerics, String suffix) {
        this.numerics = numerics;
        this.suffix = suffix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numerics.length; ++i) {
            int numeric = this.numerics[i];
            if (i > 0) {
                sb.append(".");
            }
            sb.append(numeric);
        }
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }

    public String toOsgiString() {
        if (this.numerics.length == 0) {
            return EMPTY_SUFFIX;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numerics.length; ++i) {
            int numeric = this.numerics[i];
            if (i > 0) {
                sb.append(".");
            }
            sb.append(numeric);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Arrays.hashCode(this.numerics);
        hash = 23 * hash + Objects.hashCode(this.suffix);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (!Objects.equals(this.suffix, other.suffix)) {
            return false;
        }
        return Arrays.equals(this.numerics, other.numerics);
    }

    @Override
    public int compareTo(Version o) {
        int i;
        int ls = o.numerics.length < this.numerics.length ? o.numerics.length : this.numerics.length;
        int ll = o.numerics.length > this.numerics.length ? o.numerics.length : this.numerics.length;
        for (i = 0; i < ls; ++i) {
            if (o.numerics[i] == this.numerics[i]) continue;
            return this.numerics[i] - o.numerics[i];
        }
        for (i = ls; i < ll; ++i) {
            if (o.numerics.length > i) {
                if (o.numerics[i] == 0) continue;
                return -1;
            }
            if (this.numerics.length <= i || this.numerics[i] == 0) continue;
            return 1;
        }
        if (this.suffix == o.suffix) {
            return 0;
        }
        return this.suffix.compareTo(o.suffix);
    }
}

