/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.bndly.common.app.provisioning.ProvisioningModelRenderer;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.model.ProvisioningModel;
import org.bndly.common.app.provisioning.model.RunMode;
import org.bndly.common.app.provisioning.model.StartLevelBundle;
import org.bndly.common.app.provisioning.mojo.AbstractMojo;
import org.bndly.common.app.provisioning.mojo.PackageLayout;
import org.bndly.common.app.provisioning.util.ProvisioningModelLoader;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public abstract class AbstractProvisioningMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/src/main/prov")
    protected File provisioningDirectory;
    @Parameter(alias="systemProperties", readonly=true)
    protected Properties systemPropertiesFromConfiguration;
    @Parameter(readonly=true, defaultValue="false")
    protected boolean saveProvisioningModel;
    @Parameter(readonly=true, defaultValue="true")
    protected boolean runModeConfigurations = true;
    @Deprecated
    @Parameter(defaultValue="false")
    private boolean war = false;
    @Parameter(defaultValue="classic")
    protected PackageLayout packageLayout = PackageLayout.classic;
    @Parameter
    protected List<String> additionalMainClasspathLibraries = new ArrayList<String>();
    @Component
    protected MavenProjectHelper projectHelper;
    private StringSearchInterpolator stringSearchInterpolator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.war && this.packageLayout != PackageLayout.war) {
            this.getLog().warn((CharSequence)"overwriting package layout to war. please don't use <war>true</war> anymore in your pom.xml files. use <packageLayout>war</packageLayout> instead.");
            this.packageLayout = PackageLayout.war;
        }
    }

    protected final StringSearchInterpolator getStringSearchInterpolator() {
        if (this.stringSearchInterpolator == null) {
            this.stringSearchInterpolator = new StringSearchInterpolator();
            this.init(this.stringSearchInterpolator);
        }
        return this.stringSearchInterpolator;
    }

    protected void init(StringSearchInterpolator stringSearchInterpolator) {
        stringSearchInterpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.mavenSession.getSystemProperties()));
        stringSearchInterpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.mavenSession.getUserProperties()));
        stringSearchInterpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.project.getProperties()));
    }

    protected final void writeProvisioningModel(ProvisioningModel model, String jsonFileName) throws MojoExecutionException {
        Path outputPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("prov").resolve(jsonFileName);
        this.getLog().info((CharSequence)("Writing provisioning model to '" + outputPath + "'."));
        this.deleteIfExists(outputPath);
        this.createFileAndParentDirectories(outputPath);
        try (OutputStream out = Files.newOutputStream(outputPath, StandardOpenOption.WRITE);){
            new ProvisioningModelRenderer().render(model, out);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to render provisioning model to file '" + outputPath + "'", (Exception)e);
        }
    }

    protected final void createFileAndParentDirectories(Path file) throws MojoExecutionException {
        try {
            Path parentFolder = file.getParent();
            if (!Files.isDirectory(parentFolder, new LinkOption[0])) {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to ensure the parent folder of '" + file + "' exists", (Exception)e);
        }
        try {
            Files.createFile(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create file '" + file + "'", (Exception)e);
        }
    }

    protected final void deleteIfExists(Path path) throws MojoExecutionException {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to delete '" + path + "'", (Exception)e);
        }
    }

    protected final ProvisioningModel loadProvisioningModel() throws MojoExecutionException {
        return new ProvisioningModelLoader(this.getLog()).setProvisioningDirectory(this.provisioningDirectory).setStringSearchInterpolator(this.getStringSearchInterpolator()).loadProvisioningModel();
    }

    protected final ProvisioningModel loadProvisioningModel(boolean interpolatePlaceholderStrings) throws MojoExecutionException {
        return new ProvisioningModelLoader(this.getLog()).setProvisioningDirectory(this.provisioningDirectory).setStringSearchInterpolator(this.getStringSearchInterpolator()).loadProvisioningModel(interpolatePlaceholderStrings);
    }

    protected Map<Integer, Properties> extractRunModeProperties(ProvisioningModel model) throws MojoExecutionException {
        HashMap<Integer, Properties> runModePropertiesByStartLevel = new HashMap<Integer, Properties>();
        List<RunMode> runModes = model.getRunModes();
        if (runModes != null) {
            for (RunMode runMode : runModes) {
                List<StartLevelBundle> startLevel = runMode.getBundles();
                if (startLevel == null) continue;
                for (StartLevelBundle startLevelBundle : startLevel) {
                    List<ArtifactDefinition> artifacts;
                    Properties properties = (Properties)runModePropertiesByStartLevel.get(startLevelBundle.getStartLevel());
                    if (properties == null) {
                        properties = new Properties();
                        runModePropertiesByStartLevel.put(startLevelBundle.getStartLevel(), properties);
                    }
                    if ((artifacts = startLevelBundle.getArtifacts()) == null) continue;
                    for (ArtifactDefinition artifact : artifacts) {
                        File file = this.resolveArtifactDefinitionToArtifactFile(artifact);
                        if (file == null) {
                            throw new MojoExecutionException("could not get artifact file " + artifact.toString());
                        }
                        String artifactFileName = file.toPath().getFileName().toString();
                        String existing = properties.getProperty(artifactFileName);
                        if (existing == null) {
                            properties.setProperty(artifactFileName, runMode.getName());
                            continue;
                        }
                        properties.setProperty(artifactFileName, existing + "," + runMode.getName());
                    }
                }
            }
        }
        return runModePropertiesByStartLevel;
    }

    protected Path getTargetAppFolder() throws MojoExecutionException {
        Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path targetAppFolder = this.packageLayout == PackageLayout.springboot ? target.resolve("app").resolve("SBO-INF") : target.resolve("app");
        try {
            if (Files.notExists(targetAppFolder, new LinkOption[0])) {
                Files.createDirectories(targetAppFolder, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not create target folder", (Exception)ex);
        }
        return targetAppFolder;
    }

    protected final Path getTargetJavaMainFolder() throws MojoExecutionException {
        Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path targetJavaMainFolder = target.resolve("java-main");
        try {
            if (Files.notExists(targetJavaMainFolder, new LinkOption[0])) {
                Files.createDirectories(targetJavaMainFolder, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not create target folder", (Exception)ex);
        }
        return targetJavaMainFolder;
    }

    protected final Path getManifestPath() {
        Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path manifestPath = target.resolve("META-INF").resolve("MANIFEST.MF");
        return manifestPath;
    }

    protected final String getMainClassName() {
        return "org.bndly.common.app.Main";
    }

    public void setSystemProperties(Properties systemPropertiesFromConfiguration) {
        this.systemPropertiesFromConfiguration = systemPropertiesFromConfiguration;
    }

    public void setProvisioningDirectory(File provisioningDirectory) {
        this.provisioningDirectory = provisioningDirectory;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

