/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.model;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;

public class ArtifactDefinition {
    private final String groupId;
    private final String artifactId;
    private final String packaging;
    private final String classifier;
    private final String version;

    public static ArtifactDefinition fromDependency(Dependency dependency) {
        String depClassifier = dependency.getClassifier();
        if (depClassifier != null) {
            return new ArtifactDefinition(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType() + ":" + depClassifier + ":" + dependency.getVersion());
        }
        return new ArtifactDefinition(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType() + ":" + dependency.getVersion());
    }

    public static ArtifactDefinition fromArtifact(Artifact artifact) {
        String depClassifier = artifact.getClassifier();
        if (depClassifier != null) {
            return new ArtifactDefinition(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + depClassifier + ":" + artifact.getVersion());
        }
        return new ArtifactDefinition(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getVersion());
    }

    public ArtifactDefinition(String artifactString) {
        String[] result = artifactString.split("\\:");
        if (result.length == 5) {
            this.groupId = result[0];
            this.artifactId = result[1];
            this.packaging = result[2];
            this.classifier = result[3];
            this.version = result[4];
        } else if (result.length == 4) {
            this.groupId = result[0];
            this.artifactId = result[1];
            this.packaging = result[2];
            this.classifier = null;
            this.version = result[3];
        } else {
            this.groupId = result[0];
            this.artifactId = result[1];
            this.packaging = null;
            this.classifier = null;
            this.version = result[2];
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version;
    }

    public final ArtifactDefinition reduceToGroupdIdArtifactIdVersion() {
        return new ArtifactDefinition(this.groupId + ":" + this.artifactId + ":" + this.version);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.groupId);
        hash = 29 * hash + Objects.hashCode(this.artifactId);
        hash = 29 * hash + Objects.hashCode(this.packaging);
        hash = 29 * hash + Objects.hashCode(this.classifier);
        hash = 29 * hash + Objects.hashCode(this.version);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactDefinition other = (ArtifactDefinition)obj;
        if (!Objects.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.packaging, other.packaging)) {
            return false;
        }
        if (!Objects.equals(this.classifier, other.classifier)) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGroupId()).append(":").append(this.getArtifactId());
        if (this.getPackaging() != null) {
            sb.append(":").append(this.getPackaging());
            if (this.getClassifier() != null) {
                sb.append(":").append(this.getClassifier());
            }
        }
        sb.append(":").append(this.getVersion());
        return sb.toString();
    }
}

