/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.util.ArtifactHelper;
import org.bndly.common.app.provisioning.util.ArtifactHelperImpl;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public abstract class AbstractMojo
extends org.apache.maven.plugin.AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private ArtifactResolver resolver;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArchiverManager archiverManager;
    private ArtifactHelper artifactHelper;

    protected final ArtifactHelper getArtifactHelper() {
        if (this.artifactHelper == null) {
            this.artifactHelper = new ArtifactHelperImpl(this.resolver, this.mavenSession, this.project, this.artifactHandlerManager, this.archiverManager);
        }
        return this.artifactHelper;
    }

    protected final File resolveArtifactDefinitionToArtifactFile(ArtifactDefinition artifact) throws MojoExecutionException {
        Artifact mavenArtifact = this.getArtifactHelper().loadArtifact(artifact);
        if (mavenArtifact == null) {
            throw new MojoExecutionException("could not load artifact " + artifact.toString());
        }
        File file = mavenArtifact.getFile();
        if (file == null && (mavenArtifact = this.getArtifactHelper().resolveArtifact(mavenArtifact)) != null) {
            file = mavenArtifact.getFile();
        }
        return file;
    }

    public void setArtifactHelper(ArtifactHelper artifactHelper) {
        this.artifactHelper = artifactHelper;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }
}

