/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.bndly.common.app.Environment;
import org.bndly.common.app.FelixMain;
import org.bndly.common.app.InstallableBundle;
import org.bndly.common.app.Logger;
import org.bndly.common.app.MapBasedRunModeSettings;
import org.bndly.common.app.PathInstallableBundle;
import org.bndly.common.app.RunModeSettings;
import org.bndly.common.app.provisioning.appmain.MavenEnvironment;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.model.ProvisioningModel;
import org.bndly.common.app.provisioning.model.RunMode;
import org.bndly.common.app.provisioning.model.StartLevelBundle;
import org.bndly.common.app.provisioning.mojo.AbstractProvisioningMojo;
import org.bndly.common.app.provisioning.mojo.PreparePackageMojo;
import org.bndly.common.app.provisioning.util.ArtifactHelperImpl;
import org.bndly.common.app.provisioning.util.FileInfoTester;
import org.bndly.common.app.provisioning.util.LoggerAdapter;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractStartOrRunMojo
extends AbstractProvisioningMojo {
    private Properties preparedSystemProperties;
    @Parameter(alias="runModes", property="bndly.application.runmodes")
    private String runModes;
    @Parameter(alias="artifact", property="artifact")
    private String appPackageMavenCoordinates;
    @Parameter(property="resource.overlay.directory")
    private File resourceOverlayDirectory;
    private final RunModeSettings noModeRunModeSettings = new RunModeSettings(){

        public boolean isActive(String bundleFileName) {
            return !AbstractStartOrRunMojo.this.runModeConfigurations;
        }
    };

    @Override
    public final void execute() throws MojoExecutionException, MojoFailureException {
        RunModeSettings runModeSettings;
        HashSet<String> activeRunModes;
        List deps;
        this.getLog().info((CharSequence)"start application now...");
        boolean skipCopyingResource = false;
        Path workingDir = this.getTargetAppFolder();
        if (this.appPackageMavenCoordinates == null && (deps = this.project.getDependencies()) != null) {
            for (Dependency dep : deps) {
                if (!"bndly-application".equals(dep.getType())) continue;
                this.appPackageMavenCoordinates = ArtifactHelperImpl.toString(dep);
                this.getLog().info((CharSequence)("picking " + this.appPackageMavenCoordinates + " as the provided application to start"));
                break;
            }
        }
        if (this.appPackageMavenCoordinates != null) {
            this.getLog().debug((CharSequence)("Found nonempty value in appPackageMavenCoordinates parameter - attempting to retrieve and launch '" + this.appPackageMavenCoordinates + "'"));
            Path pathToResolvedAppArchive = this.getArtifactHelper().resolvePathToArtifact(new ArtifactDefinition(this.appPackageMavenCoordinates));
            Path unpackedAppFolder = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("app-unpacked");
            this.extractArchive(pathToResolvedAppArchive, unpackedAppFolder);
            FileInfoTester fileInfoTester = new FileInfoTester(this.loadFileInfo(unpackedAppFolder), unpackedAppFolder.resolve("resources"));
            Path provisioningFile = unpackedAppFolder.resolve("provisioning-model.json");
            if (!Files.isRegularFile(provisioningFile, new LinkOption[0])) {
                throw new MojoExecutionException("could not find provisioning file at " + provisioningFile.toString() + ". maybe you did not package it?");
            }
            this.getLog().info((CharSequence)("Overriding provisioning directory to '" + this.provisioningDirectory));
            this.provisioningDirectory = provisioningFile.toFile();
            skipCopyingResource = true;
            this.moveExtractedAppToWorkingDir(workingDir, unpackedAppFolder, fileInfoTester);
        } else {
            if (!"bndly-application".equals(this.project.getPackaging())) {
                throw new MojoExecutionException("can not start bndly-application, because the project is not of the right packaging or no dependency to run is defined.");
            }
            this.getLog().info((CharSequence)("Using application home '" + workingDir + "'"));
        }
        this.copyOverlayResources(workingDir);
        List<Runnable> systemPropertiesCleanUp = this.setPropertiesAndPrepareCleanup(workingDir);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("FelixMain.unpackAppJar", Boolean.FALSE);
        config.put("FelixMain.homeFolder", workingDir.toAbsolutePath().toString());
        ProvisioningModel provisioningModel = this.loadProvisioningModel();
        if (this.runModes != null && !this.runModes.isEmpty()) {
            this.getLog().info((CharSequence)("using run modes: " + this.runModes));
            String[] split = this.runModes.split(",");
            activeRunModes = new HashSet<String>();
            for (String runMode : split) {
                activeRunModes.add(runMode);
            }
            config.put("bndly.application.runmodes", this.runModes);
            Map<Integer, Properties> runModePropertiesByStartLevel = this.extractRunModeProperties(provisioningModel);
            runModeSettings = new MapBasedRunModeSettings(runModePropertiesByStartLevel, activeRunModes);
        } else {
            this.getLog().info((CharSequence)"no active run modes");
            activeRunModes = Collections.EMPTY_SET;
            runModeSettings = this.noModeRunModeSettings;
        }
        FelixMain main = new FelixMain((Environment)new MavenEnvironment(this.project), (Logger)new LoggerAdapter(this.getLog()), config);
        if (this.saveProvisioningModel) {
            this.writeProvisioningModel(provisioningModel, "provisioning-model-app-start.json");
        }
        Map<Integer, List<InstallableBundle>> bundlesByStartLevel = this.buildBundlePathsForStartLevels(provisioningModel);
        main.setBundlesByStartLevel(bundlesByStartLevel);
        main.setActiveRunModes(activeRunModes);
        main.setRunModeSettings(runModeSettings);
        PreparePackageMojo.createConfigs(workingDir, provisioningModel, this.getLog(), null, this.runModeConfigurations);
        if (!skipCopyingResource) {
            PreparePackageMojo.copyResources(this.getArtifactHelper(), workingDir, provisioningModel, null);
        }
        this.project.setContextValue("org.bndly.common.app.FelixMain.INSTANCE", (Object)main);
        this.project.setContextValue("org.bndly.common.app.provisioning.mojo.StartMojo.SYSTEM_PROPERTY_CLEANUP", systemPropertiesCleanUp);
        this.doStartOrRun(main);
    }

    private List<Runnable> setPropertiesAndPrepareCleanup(Path workingDir) {
        ArrayList<Runnable> systemPropertiesCleanUp = new ArrayList<Runnable>();
        final Properties originalSystemProperties = System.getProperties();
        this.preparedSystemProperties = new Properties(this.systemPropertiesFromConfiguration);
        if (!this.preparedSystemProperties.stringPropertyNames().contains("FelixMain.homeFolder")) {
            this.preparedSystemProperties.setProperty("FelixMain.homeFolder", workingDir.toString() + File.separator);
        }
        if (!this.preparedSystemProperties.stringPropertyNames().contains("felix.fileinstall.dir")) {
            Path wars = Paths.get(this.preparedSystemProperties.getProperty("FelixMain.homeFolder"), new String[0]).resolve(Paths.get("wars", new String[0]));
            this.preparedSystemProperties.setProperty("felix.fileinstall.dir", wars.toString() + File.separator);
        }
        if (!this.preparedSystemProperties.stringPropertyNames().contains("bndly.application.config.dir")) {
            Path confApp = Paths.get(this.preparedSystemProperties.getProperty("FelixMain.homeFolder"), new String[0]).resolve(Paths.get("conf/app", new String[0]));
            this.preparedSystemProperties.setProperty("bndly.application.config.dir", confApp.toString() + File.separator);
        }
        if (!this.preparedSystemProperties.stringPropertyNames().contains("bndly.application.runmodes") && this.runModes != null && !this.runModes.isEmpty()) {
            this.preparedSystemProperties.setProperty("bndly.application.runmodes", this.runModes);
        }
        for (final String key : this.preparedSystemProperties.stringPropertyNames()) {
            String value = this.preparedSystemProperties.getProperty(key);
            final boolean hasOriginal = originalSystemProperties.containsKey(key);
            final String originalValue = (String)originalSystemProperties.get(key);
            originalSystemProperties.setProperty(key, value);
            this.getLog().info((CharSequence)("setting system property " + key + "=" + value));
            systemPropertiesCleanUp.add(new Runnable(){

                @Override
                public void run() {
                    if (hasOriginal) {
                        AbstractStartOrRunMojo.this.getLog().info((CharSequence)("restoring original system property " + key + "=" + originalValue));
                        originalSystemProperties.setProperty(key, originalValue);
                    } else {
                        AbstractStartOrRunMojo.this.getLog().info((CharSequence)("removing system property " + key));
                        originalSystemProperties.remove(key);
                        System.clearProperty(key);
                    }
                }
            });
        }
        return systemPropertiesCleanUp;
    }

    private void copyOverlayResources(Path workingDir) throws MojoExecutionException {
        if (this.resourceOverlayDirectory != null) {
            if (this.resourceOverlayDirectory.isDirectory()) {
                this.getLog().info((CharSequence)("Copy resource overlay from '" + this.resourceOverlayDirectory + "'"));
                try {
                    FileUtils.copyDirectoryStructure((File)this.resourceOverlayDirectory, (File)workingDir.toFile());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy contents of '" + this.resourceOverlayDirectory + "' to '" + workingDir + "'", (Exception)e);
                }
            } else {
                throw new MojoExecutionException("Configured resource overlay directory is not a valid folder: '" + this.resourceOverlayDirectory + "'");
            }
        }
    }

    private Properties loadFileInfo(Path unpackedAppFolder) throws MojoExecutionException {
        Path fileInfoFile = unpackedAppFolder.resolve("file-info.properties");
        if (!Files.isRegularFile(fileInfoFile, new LinkOption[0])) {
            throw new MojoExecutionException("could not find file info file at " + fileInfoFile.toString() + ". maybe you did not package it?");
        }
        Properties fileInfo = new Properties();
        try (InputStream is = Files.newInputStream(fileInfoFile, StandardOpenOption.READ);
             InputStreamReader r = new InputStreamReader(is, "UTF-8");){
            fileInfo.load(r);
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not read file info", (Exception)e);
        }
        return fileInfo;
    }

    private void extractArchive(Path archivePath, Path outputDirectory) throws MojoExecutionException {
        UnArchiver unArchiver;
        try {
            unArchiver = this.getArtifactHelper().getUnArchiver(archivePath.toFile());
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Failed to obtain unarchiver for '" + archivePath + "'", (Exception)((Object)e));
        }
        try {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not create output directory while extracting archive", (Exception)e);
        }
        unArchiver.setSourceFile(archivePath.toFile());
        unArchiver.setDestDirectory(outputDirectory.toFile());
        unArchiver.extract();
    }

    @Override
    protected Path getTargetAppFolder() throws MojoExecutionException {
        Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path targetAppFolder = target.resolve("app-start");
        try {
            if (Files.notExists(targetAppFolder, new LinkOption[0])) {
                Files.createDirectories(targetAppFolder, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not create target folder", (Exception)ex);
        }
        return targetAppFolder;
    }

    @Override
    protected void init(StringSearchInterpolator stringSearchInterpolator) {
        if (this.preparedSystemProperties != null) {
            stringSearchInterpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.preparedSystemProperties));
        }
        super.init(stringSearchInterpolator);
    }

    private Map<Integer, List<InstallableBundle>> buildBundlePathsForStartLevels(ProvisioningModel provisioningModel) throws MojoExecutionException {
        HashMap<Integer, List<InstallableBundle>> bundlesByStartLevel = new HashMap<Integer, List<InstallableBundle>>();
        for (RunMode runMode : provisioningModel.getRunModes()) {
            for (StartLevelBundle startLevel : runMode.getBundles()) {
                for (ArtifactDefinition artifact : startLevel.getArtifacts()) {
                    ArrayList<PathInstallableBundle> list = (ArrayList<PathInstallableBundle>)bundlesByStartLevel.get(startLevel.getStartLevel());
                    if (list == null) {
                        list = new ArrayList<PathInstallableBundle>();
                        bundlesByStartLevel.put(startLevel.getStartLevel(), list);
                    }
                    Path path = this.getArtifactHelper().resolvePathToArtifact(artifact);
                    list.add(new PathInstallableBundle(path));
                }
            }
        }
        return bundlesByStartLevel;
    }

    protected abstract void doStartOrRun(FelixMain var1) throws MojoExecutionException;

    private void moveExtractedAppToWorkingDir(final Path workingDir, Path unpackedJarFolder, final FileInfoTester fileInfoTester) throws MojoExecutionException {
        final Path extractedAppFolder = unpackedJarFolder.resolve("resources");
        try {
            Files.walkFileTree(extractedAppFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (fileInfoTester.isResourceDirectory(dir)) {
                        Path folder = workingDir.resolve(extractedAppFolder.relativize(dir));
                        Files.createDirectories(folder, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (fileInfoTester.isBundle(file) || fileInfoTester.isResource(file)) {
                        Path f = workingDir.resolve(extractedAppFolder.relativize(file));
                        Path parentFolder = f.getParent();
                        Files.createDirectories(parentFolder, new FileAttribute[0]);
                        Files.deleteIfExists(f);
                        Files.copy(file, f, new CopyOption[0]);
                    } else if (fileInfoTester.isConfig(file)) {
                        // empty if block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not move extracted app to working directory", (Exception)e);
        }
    }
}

