/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.bndly.common.app.provisioning.mojo.ExportableJar;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL)
public class BundleInstallMojo
extends AbstractMojo {
    private static final String BUNDLE_HEADER_BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final ContentType CT_JAR_ARCHIVE = ContentType.create((String)"application/java-archive");
    private static final String REQ_HEADER_REFERER = "Referer";
    private static final String REQ_PARAM_ACTION = "action";
    private static final String REQ_PARAMVALUE_ACTION_INSTALL = "install";
    private static final String REQ_PARAM_NO_REDIRECT = "_noredir_";
    private static final String REQ_PARAMVALUE_NO_REDIRECT = "_noredir_";
    private static final String REQ_PARAM_BUNDLE_START = "bundlestart";
    private static final String REQ_PARAMVALUE_BUNDLE_START = "start";
    private static final String REQ_PARAM_REFRESH_PACKAGES = "refreshPackages";
    private static final String REQ_PARAMVALUE_REFRESH_PACKAGES = "refresh";
    private static final String REQ_PARAM_BUNDLE_START_LEVEL = "bundlestartlevel";
    private static final String REQ_PARAMVALUE_BUNDLE_START_LEVEL = "1";
    private static final String REQ_PARAM_FILE = "bundlefile";
    @Parameter(property="bndly.install.skip", defaultValue="false", required=true)
    protected boolean skipInstallation;
    @Parameter(property="bndly.webConsoleUrl", defaultValue="http://localhost:8082/system/console/bundles/install", required=true)
    protected String webConsoleUrl;
    @Parameter(property="bndly.user", required=false)
    protected String basicAuthUser;
    @Parameter(property="bndly.password", required=false)
    protected String basicAuthPassword;
    @Parameter(property="bndly.ssl.hostnameverifier", required=false)
    protected String hostnameverifier;
    @Parameter(property="bndly.ssl.truststore", required=false)
    protected String truststore;
    @Parameter(property="bndly.ssl.truststore.password", required=false)
    protected String truststorePassword;
    @Parameter(property="bndly.ssl.protocols", required=false, alias="sslProtocols")
    protected String[] sslProtocols;
    @Parameter(property="bndly.ssl.ciphersuites", required=false, alias="sslCipherSuites")
    protected String[] sslCipherSuites;
    @Parameter(property="bndly.ssl.trustSelfSignedCerts", defaultValue="false", required=true)
    protected boolean trustSelfSignedCerts;
    @Parameter(property="bndly.bundle.file", defaultValue="${project.build.directory}/${project.build.finalName}.jar", required=true)
    protected String bundleFileName;
    @Parameter(property="bndly.bundle.startlevel", defaultValue="1", required=true)
    protected String bundleStartLevel;
    @Parameter(property="bndly.bundle.start", defaultValue="true", required=true)
    protected boolean bundleStart;
    @Parameter(property="bndly.refreshPackages", defaultValue="true", required=true)
    protected boolean refreshPackages;
    @Parameter(property="bndly.installDependencies", defaultValue="false", required=true)
    protected boolean installDependencies;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.dependencies}", readonly=true)
    protected List<Dependency> dependencies;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ArtifactResolver resolver;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ProjectBuilder projectBuilder;

    private ArtifactFilter createProjectDependenciesArtifactFilter() {
        ArrayList<String> projectDependencyPatterns = new ArrayList<String>();
        for (Dependency dependency : this.dependencies) {
            projectDependencyPatterns.add(ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId()));
        }
        return new IncludesArtifactFilter(projectDependencyPatterns);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipInstallation) {
            this.getLog().debug((CharSequence)"bundle won't be installed, because installation is configured to be skipped");
            return;
        }
        if (this.installDependencies) {
            if (this.dependencies != null) {
                LinkedHashMap<String, ExportableJar> exportableJars = new LinkedHashMap<String, ExportableJar>();
                ArtifactFilter projectDependencyArtifactFilter = this.createProjectDependenciesArtifactFilter();
                for (Dependency dependency : this.dependencies) {
                    String scope = dependency.getScope();
                    String type = dependency.getType();
                    if (!"compile".equals(scope) && !"runtime".equals(scope) || type != null && !"jar".equals(type)) continue;
                    new ExportableJar(dependency, this.session, this.project, this.resolver, this.projectBuilder, this.dependencyGraphBuilder, projectDependencyArtifactFilter, this.getLog()).putInto(exportableJars);
                }
                for (ExportableJar exportableJar : exportableJars.values()) {
                    exportableJar.init(exportableJars);
                }
                ArrayList<Path> pathToInstallableBundles = new ArrayList<Path>();
                for (ExportableJar exportableJar : exportableJars.values()) {
                    File fileOfArtiact;
                    Artifact artifact = exportableJar.getArtifact();
                    if (artifact == null || (fileOfArtiact = artifact.getFile()) == null) continue;
                    Path bundleFilePath = fileOfArtiact.toPath();
                    try {
                        if (!this.isOsgiBundle(bundleFilePath)) {
                            continue;
                        }
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("could not verify, that " + bundleFilePath + " is an OSGI bundle");
                    }
                    pathToInstallableBundles.add(bundleFilePath);
                }
                if (pathToInstallableBundles.isEmpty()) {
                    this.getLog().info((CharSequence)"no bundles to install");
                    return;
                }
                this.installBundleViaWebConsole(pathToInstallableBundles.toArray(new Path[0]));
            }
        } else {
            Path bundleFilePath = Paths.get(this.bundleFileName, new String[0]);
            if (!Files.exists(bundleFilePath, new LinkOption[0]) || !Files.isRegularFile(bundleFilePath, new LinkOption[0])) {
                throw new MojoExecutionException("can not install bundle, because " + this.bundleFileName + " is not a file");
            }
            try {
                if (!this.isOsgiBundle(bundleFilePath)) {
                    throw new MojoExecutionException("can not install file, because " + this.bundleFileName + " is not an OSGI bundle");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not verify, that " + this.bundleFileName + " is an OSGI bundle");
            }
            this.installBundleViaWebConsole(bundleFilePath);
        }
    }

    private boolean isOsgiBundle(Path bundleFilePath) throws IOException {
        try (JarFile jarFile = new JarFile(bundleFilePath.toFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                this.getLog().error((CharSequence)("no manifest in " + bundleFilePath));
                boolean bl = false;
                return bl;
            }
            String symbolicName = manifest.getMainAttributes().getValue(BUNDLE_HEADER_BUNDLE_SYMBOLIC_NAME);
            if (symbolicName == null) {
                this.getLog().error((CharSequence)("no Bundle-SymbolicName header in the bundle " + bundleFilePath));
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void installBundleViaWebConsole(Path ... bundleFilePaths) throws MojoExecutionException {
        block13: {
            HttpPost httpPost = new HttpPost(this.webConsoleUrl);
            httpPost.addHeader(REQ_HEADER_REFERER, "about:blank");
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addTextBody(REQ_PARAM_ACTION, REQ_PARAMVALUE_ACTION_INSTALL).addTextBody("_noredir_", "_noredir_");
            for (Path bundleFilePath : bundleFilePaths) {
                entityBuilder.addBinaryBody(REQ_PARAM_FILE, bundleFilePath.toFile(), CT_JAR_ARCHIVE, bundleFilePath.getFileName().toString());
            }
            entityBuilder.addTextBody(REQ_PARAM_BUNDLE_START_LEVEL, this.getStartLevel());
            if (this.bundleStart) {
                entityBuilder.addTextBody(REQ_PARAM_BUNDLE_START, REQ_PARAMVALUE_BUNDLE_START);
            }
            if (this.refreshPackages) {
                entityBuilder.addTextBody(REQ_PARAM_REFRESH_PACKAGES, REQ_PARAMVALUE_REFRESH_PACKAGES);
            }
            httpPost.setEntity(entityBuilder.build());
            try (CloseableHttpClient httpClient = this.createHttpClient();){
                Integer statusCode;
                BasicHttpContext ctx = new BasicHttpContext();
                if (this.webConsoleUrl.endsWith("/install")) {
                    String authUrl = this.webConsoleUrl.substring(0, this.webConsoleUrl.length() - "/install".length());
                    HttpGet authenticationPreflight = new HttpGet(authUrl);
                    Integer statusCode2 = (Integer)httpClient.execute((HttpUriRequest)authenticationPreflight, (ResponseHandler)new ResponseHandler<Integer>(){

                        public Integer handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                            return response.getStatusLine().getStatusCode();
                        }
                    }, (HttpContext)ctx);
                    this.getLog().info((CharSequence)("auth preflight got: " + statusCode2));
                }
                if ((statusCode = (Integer)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)new ResponseHandler<Integer>(){

                    public Integer handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                        return response.getStatusLine().getStatusCode();
                    }
                }, (HttpContext)ctx)) == 200) {
                    this.getLog().info((CharSequence)"installed bundle");
                    break block13;
                }
                throw new MojoExecutionException("could not install bundle. got status code " + statusCode);
            }
            catch (IOException e) {
                throw new MojoExecutionException("could not install bundle", (Exception)e);
            }
        }
    }

    private String getStartLevel() {
        return this.bundleStartLevel == null ? REQ_PARAMVALUE_BUNDLE_START_LEVEL : this.bundleStartLevel;
    }

    private CloseableHttpClient createHttpClient() throws MojoExecutionException {
        boolean isCustomSslContextRequired;
        X509HostnameVerifier hnv;
        HttpClientBuilder clientBuilder;
        block22: {
            block20: {
                block21: {
                    clientBuilder = HttpClientBuilder.create();
                    if (this.basicAuthUser != null) {
                        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.basicAuthUser, this.basicAuthPassword));
                        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
                    }
                    if (this.hostnameverifier == null) break block20;
                    HOSTNAME_VERIFIER hostnameVerifierValue = HOSTNAME_VERIFIER.valueOf(this.hostnameverifier);
                    if (null == hostnameVerifierValue) break block21;
                    switch (hostnameVerifierValue) {
                        case all: {
                            hnv = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                            clientBuilder.setHostnameVerifier(hnv);
                            break block22;
                        }
                        case browser: {
                            hnv = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
                            clientBuilder.setHostnameVerifier(hnv);
                            break block22;
                        }
                        case strict: {
                            hnv = SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER;
                            clientBuilder.setHostnameVerifier(hnv);
                            break block22;
                        }
                        default: {
                            throw new MojoExecutionException("unsupported hostname verifier " + (Object)((Object)hostnameVerifierValue));
                        }
                    }
                }
                hnv = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
                clientBuilder.setHostnameVerifier(hnv);
                break block22;
            }
            hnv = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
            clientBuilder.setHostnameVerifier(hnv);
        }
        boolean bl = isCustomSslContextRequired = this.trustSelfSignedCerts || this.truststore != null;
        if (isCustomSslContextRequired && this.truststore != null) {
            SSLContext sslcontext;
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            try (InputStream is = Files.newInputStream(Paths.get(this.truststore, new String[0]), StandardOpenOption.READ);){
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(is, this.truststorePassword == null ? null : this.truststorePassword.toCharArray());
                if (this.trustSelfSignedCerts) {
                    sslContextBuilder.loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy());
                } else {
                    sslContextBuilder.loadTrustMaterial(keyStore);
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new MojoExecutionException("could not set up custom truststore", ex);
            }
            try {
                sslcontext = sslContextBuilder.build();
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                throw new MojoExecutionException("could not setup SSL context", (Exception)ex);
            }
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslcontext, this.nonEmptyArray(this.sslProtocols), this.nonEmptyArray(this.sslCipherSuites), hnv);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
        }
        return clientBuilder.build();
    }

    private String[] nonEmptyArray(String[] input) {
        if (input == null || input.length == 0) {
            return null;
        }
        return input;
    }

    private static enum HOSTNAME_VERIFIER {
        all,
        browser,
        strict;

    }
}

