/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.mojo.AbstractMojo;
import org.bndly.common.app.provisioning.util.ExportPackageUtil;
import org.bndly.common.app.provisioning.util.Version;

@Mojo(name="derivePackages", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class DeriveDependencyPackagesMojo
extends AbstractMojo {
    public static final String NO_VERSION_PREFIX = "**";
    public static final String ADD_VERSION_PREFIX = "++";
    @Parameter
    protected String dependencyOverrides;
    @Parameter
    protected String excludes;
    @Parameter
    protected boolean excludeOsgiBundles;
    @Parameter(defaultValue="META-INF.*,WEB-INF.*")
    protected String packageExcludes = "META-INF.*,WEB-INF.*";
    @Parameter(defaultValue="dependencyPackages")
    protected String projectProperty = "dependencyPackages";
    @Component
    private DependencyTreeBuilder dependencyTreeBuilder;

    private Config createConfig() {
        final HashSet<ArtifactDefinition> skipVersionInfoForArtifactDefinitions = new HashSet<ArtifactDefinition>();
        final HashSet<ArtifactDefinition> additionalVersionInfoForArtifactDefinitions = new HashSet<ArtifactDefinition>();
        final HashSet<ArtifactDefinition> excludedDefinitions = new HashSet<ArtifactDefinition>();
        if (this.excludes != null) {
            for (String string : this.excludes.split(",")) {
                String trimmedEntry = string.trim();
                ArtifactDefinition artifactDefinition = new ArtifactDefinition(trimmedEntry);
                excludedDefinitions.add(artifactDefinition);
            }
        }
        final HashSet<ArtifactDefinition> overrideDefinitions = new HashSet<ArtifactDefinition>();
        final HashMap<String, ArtifactDefinition> overrideDefinitionsByGroupdIdArtifactId = new HashMap<String, ArtifactDefinition>();
        if (this.dependencyOverrides != null) {
            for (String string : this.dependencyOverrides.split(",")) {
                String trimmedEntry = string.trim();
                boolean skipVersionInfo = trimmedEntry.startsWith(NO_VERSION_PREFIX);
                boolean additionalVersionInfo = trimmedEntry.startsWith(ADD_VERSION_PREFIX);
                if (skipVersionInfo) {
                    trimmedEntry = trimmedEntry.substring(NO_VERSION_PREFIX.length());
                } else if (additionalVersionInfo) {
                    trimmedEntry = trimmedEntry.substring(ADD_VERSION_PREFIX.length());
                }
                ArtifactDefinition artifactDefinition = new ArtifactDefinition(trimmedEntry);
                if (skipVersionInfo) {
                    skipVersionInfoForArtifactDefinitions.add(artifactDefinition);
                } else if (additionalVersionInfo) {
                    additionalVersionInfoForArtifactDefinitions.add(artifactDefinition);
                }
                overrideDefinitionsByGroupdIdArtifactId.put(artifactDefinition.getGroupId() + ":" + artifactDefinition.getArtifactId(), artifactDefinition);
                overrideDefinitions.add(artifactDefinition);
            }
        }
        excludedDefinitions.add(ArtifactDefinition.fromArtifact(this.project.getArtifact()));
        String[] packageExcludesSplit = this.packageExcludes.split(",");
        final HashSet<String> wildcardExcludes = new HashSet<String>();
        final HashSet<String> explicitExcludes = new HashSet<String>();
        for (String packageExclude : packageExcludesSplit) {
            if (packageExclude.endsWith(".*")) {
                wildcardExcludes.add(packageExclude.substring(0, packageExclude.length() - ".*".length()));
                continue;
            }
            explicitExcludes.add(packageExclude);
        }
        return new Config(){

            @Override
            public boolean isExcluded(Dependency dependency) {
                return this.isExcluded(ArtifactDefinition.fromDependency(dependency));
            }

            @Override
            public boolean isExcluded(Artifact artifact) {
                return this.isExcluded(ArtifactDefinition.fromArtifact(artifact));
            }

            @Override
            public boolean isExcluded(ArtifactDefinition artifactDefinition) {
                String packaging = artifactDefinition.getPackaging();
                if ("jar".equals(packaging) || "war".equals(packaging) || "bundle".equals(packaging)) {
                    return excludedDefinitions.contains(artifactDefinition) || overrideDefinitionsByGroupdIdArtifactId.containsKey(artifactDefinition.getGroupId() + ":" + artifactDefinition.getArtifactId());
                }
                return true;
            }

            @Override
            public Iterable<ArtifactDefinition> getOverrideDefinitions() {
                return overrideDefinitions;
            }

            @Override
            public boolean isVersionInfoSkipped(ArtifactDefinition artifactDefinition) {
                return skipVersionInfoForArtifactDefinitions.contains(artifactDefinition);
            }

            @Override
            public boolean isAdditionalVersionInfoAvailable(ArtifactDefinition artifactDefinition) {
                return additionalVersionInfoForArtifactDefinitions.contains(artifactDefinition);
            }

            @Override
            public boolean isExcludedPackage(String packageName) {
                if (explicitExcludes.contains(packageName)) {
                    return true;
                }
                if (wildcardExcludes.contains(packageName)) {
                    return true;
                }
                String[] packageElements = packageName.split("\\.");
                for (int i = 1; i < packageElements.length; ++i) {
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (int j = 0; j < packageElements.length - i; ++j) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(".");
                        }
                        sb.append(packageElements[j]);
                    }
                    if (!wildcardExcludes.contains(sb.toString())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Config config = this.createConfig();
        Set<ArtifactDefinition> defs = this.collectArtifactsFromDependencies(config);
        this.addArtifactsFromConfigOverrides(config, defs);
        Map<String, ScannedPackages> scannedPackagesByPackageName = this.scanJavaPackagesInArtifacts(config, defs);
        final ArrayList conflicts = new ArrayList();
        List<ScannedPackage> scannedPackagesList = this.mergeJavaPackageAndResolveConflicts(scannedPackagesByPackageName, new Consumer<Conflict>(){

            @Override
            public void accept(Conflict conflict) {
                conflicts.add(conflict);
            }
        });
        if (!conflicts.isEmpty()) {
            this.getLog().error((CharSequence)"conflicts:");
            for (Conflict conflict : conflicts) {
                this.getLog().error((CharSequence)("" + conflict.getOne() + " VS " + conflict.getTwo()));
            }
            throw new MojoExecutionException("version conflicts found. please use either override mechanism using '++' prefix or exclude conflicting artifacts manually.");
        }
        StringBuilder sb = this.createPropertyStringWithJavaPackages(scannedPackagesList);
        String packageString = sb.toString();
        this.getLog().debug((CharSequence)packageString);
        this.project.getProperties().setProperty(this.projectProperty, packageString);
        System.setProperty(this.projectProperty, packageString);
    }

    private StringBuilder createPropertyStringWithJavaPackages(List<ScannedPackage> scannedPackagesList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Collections.sort(scannedPackagesList, new Comparator<ScannedPackage>(){

            @Override
            public int compare(ScannedPackage o1, ScannedPackage o2) {
                return o1.javaPackage.compareTo(o2.javaPackage);
            }
        });
        for (ScannedPackage value : scannedPackagesList) {
            for (Version version : value.versions) {
                String v;
                if (first) {
                    first = false;
                } else {
                    sb.append(", \\\n");
                }
                sb.append(value.javaPackage);
                if (value.versionType == VersionType.SKIP || value.versionType == VersionType.ARTIFACT_VERSION || value.versionType == VersionType.BUNDLE_VERSION || (v = version.toOsgiString()).isEmpty()) continue;
                sb.append(";version=\"").append(v).append("\"");
            }
        }
        return sb;
    }

    private List<ScannedPackage> mergeJavaPackageAndResolveConflicts(Map<String, ScannedPackages> scannedPackagesByPackageName, Consumer<Conflict> conflictConsumer) throws MojoExecutionException {
        ArrayList<ScannedPackage> scannedPackagesList = new ArrayList<ScannedPackage>();
        for (ScannedPackages scannedPackages : scannedPackagesByPackageName.values()) {
            Iterator<ScannedPackage> iterator = scannedPackages.scannedPackages.iterator();
            ScannedPackage existingPackage = null;
            while (iterator.hasNext()) {
                ScannedPackage scannedPackage = iterator.next();
                if (scannedPackages.packagesForMerge.contains(scannedPackage)) continue;
                if (existingPackage == null) {
                    existingPackage = scannedPackage;
                    continue;
                }
                if (existingPackage.version.compareTo(scannedPackage.version) == 0 || existingPackage.versionType == VersionType.ARTIFACT_VERSION && scannedPackage.versionType == VersionType.ARTIFACT_VERSION) continue;
                if (existingPackage.versionType == VersionType.ARTIFACT_VERSION && scannedPackage.versionType != VersionType.ARTIFACT_VERSION) {
                    existingPackage = scannedPackage;
                    continue;
                }
                if (existingPackage.versionType != VersionType.ARTIFACT_VERSION && scannedPackage.versionType == VersionType.ARTIFACT_VERSION) continue;
                if (existingPackage.sourceArtifact.equals(scannedPackage.sourceArtifact)) {
                    this.getLog().warn((CharSequence)("artifact internal version conflict: " + existingPackage + " VS " + scannedPackage));
                    continue;
                }
                final ScannedPackage one = existingPackage;
                final ScannedPackage two = scannedPackage;
                conflictConsumer.accept(new Conflict(){

                    @Override
                    public ScannedPackage getOne() {
                        return one;
                    }

                    @Override
                    public ScannedPackage getTwo() {
                        return two;
                    }
                });
            }
            for (ScannedPackage scannedPackage : scannedPackages.packagesForMerge) {
                existingPackage = existingPackage == null ? scannedPackage : existingPackage.withFurtherVersion(scannedPackage.version);
            }
            scannedPackagesList.add(existingPackage);
        }
        return scannedPackagesList;
    }

    private Map<String, ScannedPackages> scanJavaPackagesInArtifacts(final Config config, Iterable<ArtifactDefinition> defs) throws MojoExecutionException {
        HashMap<String, ScannedPackages> scannedPackagesByPackageName = new HashMap<String, ScannedPackages>();
        for (final ArtifactDefinition artifactDefinition : defs) {
            File artifactFile = this.resolveArtifactDefinitionToArtifactFile(artifactDefinition);
            if (artifactFile == null) {
                throw new MojoExecutionException("no file for artifact " + artifactDefinition);
            }
            try {
                String bundleVersion;
                String exportPackages;
                JarFile jarFile = new JarFile(artifactFile);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    Attributes mainAttributes = manifest.getMainAttributes();
                    if (mainAttributes != null) {
                        exportPackages = mainAttributes.getValue("Export-Package");
                        bundleVersion = mainAttributes.getValue("Bundle-Version");
                    } else {
                        exportPackages = null;
                        bundleVersion = null;
                    }
                } else {
                    exportPackages = null;
                    bundleVersion = null;
                }
                if (exportPackages != null) {
                    if (this.excludeOsgiBundles) continue;
                    this.getLog().debug((CharSequence)("scanned " + artifactDefinition));
                    this.getLog().debug((CharSequence)("Export-Packages: " + exportPackages));
                    final ArrayList scannedPackages = new ArrayList();
                    ExportPackageUtil.parse(exportPackages, new ExportPackageUtil.PackageConsumer(){

                        @Override
                        public void consumePackage(String packageName, List<String> metaData) {
                            ScannedPackage sp;
                            if (config.isExcludedPackage(packageName)) {
                                return;
                            }
                            String version = ExportPackageUtil.getVersionFromMetaData(metaData);
                            if (version != null) {
                                sp = new ScannedPackage(artifactDefinition, config.isVersionInfoSkipped(artifactDefinition) ? VersionType.SKIP : VersionType.EXPORT_PACKAGE, packageName, version);
                            } else {
                                String message = "package " + packageName + " from dependency " + artifactDefinition + " has no version: " + exportPackages;
                                if (bundleVersion == null) {
                                    DeriveDependencyPackagesMojo.this.getLog().warn((CharSequence)message);
                                    sp = new ScannedPackage(artifactDefinition, config.isVersionInfoSkipped(artifactDefinition) ? VersionType.SKIP : VersionType.ARTIFACT_VERSION, packageName, artifactDefinition.getVersion());
                                } else {
                                    DeriveDependencyPackagesMojo.this.getLog().debug((CharSequence)message);
                                    sp = new ScannedPackage(artifactDefinition, config.isVersionInfoSkipped(artifactDefinition) ? VersionType.SKIP : VersionType.BUNDLE_VERSION, packageName, bundleVersion);
                                }
                            }
                            scannedPackages.add(sp);
                        }
                    });
                    for (ScannedPackage scannedPackage : scannedPackages) {
                        this.put(scannedPackagesByPackageName, scannedPackage.sourceArtifact, scannedPackage.versionType, scannedPackage.javaPackage, scannedPackage.version.toString(), config);
                    }
                    continue;
                }
                HashSet<String> packages = new HashSet<String>();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String packageName;
                    String className;
                    int pckEnd;
                    JarEntry jarEntry = entries.nextElement();
                    String entryName = jarEntry.getName();
                    if (!entryName.endsWith(".class") || (pckEnd = (className = entryName.substring(0, entryName.length() - ".class".length())).lastIndexOf("/")) <= -1 || config.isExcludedPackage(packageName = className.substring(0, pckEnd).replaceAll("/", "."))) continue;
                    packages.add(packageName.trim());
                }
                this.getLog().debug((CharSequence)("scanned " + artifactDefinition));
                for (String packageName : packages) {
                    this.put(scannedPackagesByPackageName, artifactDefinition, VersionType.ARTIFACT_VERSION, packageName, artifactDefinition.getVersion(), config);
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not unpack " + artifactDefinition, (Exception)ex);
            }
        }
        return scannedPackagesByPackageName;
    }

    private void addArtifactsFromConfigOverrides(Config config, Set<ArtifactDefinition> defs) {
        for (ArtifactDefinition overrideDefinition : config.getOverrideDefinitions()) {
            this.getLog().info((CharSequence)("adding override dependency: " + overrideDefinition));
            defs.add(overrideDefinition);
        }
    }

    private Set<ArtifactDefinition> collectArtifactsFromDependencies(final Config config) throws MojoExecutionException {
        ArtifactFilter af = new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !config.isExcluded(artifact);
            }
        };
        final HashSet<ArtifactDefinition> defs = new HashSet<ArtifactDefinition>();
        try {
            this.dependencyTreeBuilder.buildDependencyTree(this.project, this.mavenSession.getLocalRepository(), af).accept(new DependencyNodeVisitor(){

                public boolean visit(DependencyNode dn) {
                    Artifact artifact = dn.getArtifact();
                    ArtifactDefinition artifactDefinition = ArtifactDefinition.fromArtifact(artifact);
                    if (!config.isExcluded(artifactDefinition)) {
                        defs.add(artifactDefinition);
                    }
                    return true;
                }

                public boolean endVisit(DependencyNode dn) {
                    return true;
                }
            });
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("could not build dependency tree", (Exception)((Object)e));
        }
        return defs;
    }

    private void put(Map<String, ScannedPackages> scannedPackagesByPackageName, ArtifactDefinition sourceArtifact, VersionType versionType, String packageName, String version, Config config) throws MojoExecutionException {
        ScannedPackage scannedPackage = new ScannedPackage(sourceArtifact, versionType, packageName, version);
        ScannedPackages existingPackages = scannedPackagesByPackageName.get(packageName);
        if (existingPackages == null) {
            existingPackages = new ScannedPackages(packageName);
            scannedPackagesByPackageName.put(packageName, existingPackages);
        }
        if (config.isAdditionalVersionInfoAvailable(sourceArtifact)) {
            existingPackages.addMerged(scannedPackage);
        } else {
            existingPackages.add(scannedPackage);
        }
    }

    private static interface Conflict {
        public ScannedPackage getOne();

        public ScannedPackage getTwo();
    }

    private static interface Config {
        public boolean isExcluded(Dependency var1);

        public boolean isExcluded(Artifact var1);

        public boolean isExcluded(ArtifactDefinition var1);

        public boolean isExcludedPackage(String var1);

        public Iterable<ArtifactDefinition> getOverrideDefinitions();

        public boolean isVersionInfoSkipped(ArtifactDefinition var1);

        public boolean isAdditionalVersionInfoAvailable(ArtifactDefinition var1);
    }

    private static class ScannedPackage {
        final ArtifactDefinition sourceArtifact;
        final VersionType versionType;
        final Version version;
        final Version[] versions;
        final String javaPackage;

        public ScannedPackage(ArtifactDefinition sourceArtifact, VersionType versionType, String javaPackage, String version) {
            this(sourceArtifact, versionType, javaPackage, version == null ? null : Version.from(version));
        }

        private ScannedPackage(ArtifactDefinition sourceArtifact, VersionType versionType, String javaPackage, Version ... versions) {
            if (sourceArtifact == null) {
                throw new IllegalArgumentException("source artifact is not allowed to be null");
            }
            this.sourceArtifact = sourceArtifact;
            if (javaPackage == null) {
                throw new IllegalArgumentException("java package is not allowed to be null: " + javaPackage);
            }
            this.javaPackage = javaPackage;
            if (versionType == null) {
                throw new IllegalArgumentException("version type is not allowed to be null: " + sourceArtifact + "->" + javaPackage);
            }
            this.versionType = versionType;
            if (versions == null) {
                throw new IllegalArgumentException("versions is not allowed to be null: " + sourceArtifact + "->" + javaPackage + "[" + (Object)((Object)versionType) + "]");
            }
            this.versions = versions;
            this.version = versions[0];
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + Objects.hashCode(this.sourceArtifact);
            hash = 17 * hash + Objects.hashCode((Object)this.versionType);
            hash = 17 * hash + Objects.hashCode(this.javaPackage);
            hash = 17 * hash + Objects.hashCode(this.version);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScannedPackage other = (ScannedPackage)obj;
            if (!Objects.equals(this.javaPackage, other.javaPackage)) {
                return false;
            }
            if (!Objects.equals(this.version, other.version)) {
                return false;
            }
            if (!Objects.equals(this.sourceArtifact, other.sourceArtifact)) {
                return false;
            }
            return this.versionType == other.versionType;
        }

        public String toString() {
            return this.sourceArtifact.toString() + "->" + this.javaPackage + "=" + this.version + "[" + (Object)((Object)this.versionType) + "]";
        }

        public ScannedPackage withFurtherVersion(Version version) {
            ArrayList<Version> versions = new ArrayList<Version>(Arrays.asList(this.versions));
            versions.add(version);
            return new ScannedPackage(this.sourceArtifact, this.versionType, this.javaPackage, versions.toArray(new Version[versions.size()]));
        }
    }

    private static class ScannedPackages {
        final List<ScannedPackage> scannedPackages;
        final Set<ScannedPackage> packagesForMerge;
        final String javaPackage;

        public ScannedPackages(String javaPackage) {
            if (javaPackage == null) {
                throw new IllegalArgumentException("java package is not allowed to be null: " + javaPackage);
            }
            this.javaPackage = javaPackage;
            this.scannedPackages = new ArrayList<ScannedPackage>();
            this.packagesForMerge = new HashSet<ScannedPackage>();
        }

        private ScannedPackages add(ScannedPackage scannedPackage) {
            this.scannedPackages.add(scannedPackage);
            return this;
        }

        private ScannedPackages addMerged(ScannedPackage scannedPackage) {
            this.scannedPackages.add(scannedPackage);
            this.packagesForMerge.add(scannedPackage);
            return this;
        }
    }

    private static enum VersionType {
        EXPORT_PACKAGE,
        BUNDLE_VERSION,
        ARTIFACT_VERSION,
        SKIP;

    }
}

