/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class ExportableJar {
    private final Dependency dependency;
    private final MavenSession mavenSession;
    private final MavenProject project;
    private final ArtifactResolver resolver;
    private final ProjectBuilder projectBuilder;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final ArtifactFilter projectDependencyArtifactFilter;
    private final Log log;
    private final List<ExportableJar> transitiveExportedDependencies;
    private Artifact artifact;

    public ExportableJar(Dependency dependency, MavenSession mavenSession, MavenProject project, ArtifactResolver resolver, ProjectBuilder projectBuilder, DependencyGraphBuilder dependencyGraphBuilder, ArtifactFilter projectDependencyArtifactFilter, Log log) {
        this.dependency = dependency;
        this.mavenSession = mavenSession;
        this.project = project;
        this.resolver = resolver;
        this.projectBuilder = projectBuilder;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.projectDependencyArtifactFilter = projectDependencyArtifactFilter;
        this.log = log;
        this.transitiveExportedDependencies = new ArrayList<ExportableJar>();
    }

    public ExportableJar init(Map<String, ExportableJar> exportableJars) throws MojoExecutionException {
        DependencyNode graph;
        ProjectBuildingResult result;
        this.artifact = this.resolveArtifact(this.dependency);
        if (this.artifact == null || this.artifact.getFile() == null) {
            throw new MojoExecutionException("could not retrieve file location for " + this.dependency);
        }
        List reactor = this.mavenSession.getProjects();
        ProjectBuildingRequest request = this.mavenSession.getProjectBuildingRequest();
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(request);
        try {
            result = this.projectBuilder.build(this.artifact, request);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("could not build maven project in order to resolve dependencies of dependency from " + this.artifact, (Exception)((Object)e));
        }
        buildingRequest.setProject(result.getProject());
        try {
            graph = this.dependencyGraphBuilder.buildDependencyGraph(this.project, this.projectDependencyArtifactFilter, (Collection)reactor);
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("could not build dependency graph for artifact " + this.artifact, (Exception)((Object)e));
        }
        CollectingDependencyNodeVisitor collector = new CollectingDependencyNodeVisitor();
        graph.accept((DependencyNodeVisitor)collector);
        for (DependencyNode node : collector.getNodes()) {
            String scope = node.getArtifact().getScope();
            if (!"compile".equals(scope) && !"runtime".equals(scope)) {
                this.log.debug((CharSequence)("skip dependency " + node.getArtifact() + " because scope " + scope + " differs [compile,runtime]"));
                continue;
            }
            String type = node.getArtifact().getType();
            if (type != null && !"jar".equals(type)) {
                this.log.debug((CharSequence)("skip dependency " + node.getArtifact() + " because type " + type + " differs [jar]"));
                continue;
            }
            if (ArtifactUtils.key((Artifact)this.artifact).equals(ArtifactUtils.key((Artifact)node.getArtifact()))) {
                this.log.debug((CharSequence)("skip dependency " + node.getArtifact()));
                continue;
            }
            this.log.debug((CharSequence)("found transitive exported dependency " + node.getArtifact() + " for dependency " + this.dependency));
            ExportableJar dep = exportableJars.get(ArtifactUtils.versionlessKey((Artifact)node.getArtifact()));
            if (dep == null) {
                throw new MojoExecutionException("could not find exportable jar for " + node.getArtifact());
            }
            this.transitiveExportedDependencies.add(dep);
        }
        return this;
    }

    public ExportableJar putInto(Map<String, ExportableJar> exportableJars) {
        exportableJars.put(ArtifactUtils.versionlessKey((String)this.getDependency().getGroupId(), (String)this.getDependency().getArtifactId()), this);
        return this;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    private final Artifact resolveArtifact(Dependency dependency) throws MojoExecutionException {
        DefaultArtifactHandler artifactHandler = new DefaultArtifactHandler("jar");
        artifactHandler.setLanguage("java");
        DefaultArtifact artifactTmp = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), (ArtifactHandler)artifactHandler);
        return this.resolveArtifact((Artifact)artifactTmp);
    }

    private final Artifact resolveArtifact(Artifact artifact) throws MojoExecutionException {
        Artifact found;
        if (artifact.getFile() == null && artifact.isResolved() && (found = this.mavenSession.getLocalRepository().find(artifact)) != null && found.getFile() != null) {
            return found;
        }
        ArtifactResolutionResult result = this.resolver.resolve(new ArtifactResolutionRequest().setArtifact(artifact).setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setLocalRepository(this.mavenSession.getLocalRepository()));
        List exceptions = result.getExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            throw new MojoExecutionException("could not resolve artifact", (Exception)exceptions.get(0));
        }
        Set resultArtifacts = result.getArtifacts();
        if (resultArtifacts.isEmpty()) {
            throw new MojoExecutionException("could not find artifact: " + artifact);
        }
        return (Artifact)resultArtifacts.iterator().next();
    }
}

