/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExportPackageUtil {
    private static int S_PACKAGE = 0;
    private static int S_META_DATA_CONTENT = 2;
    private static int S_META_DATA_CONTENT_QUOTED = 3;
    private static int S_NEXT = 4;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^version=(?:([^\\r\\n\\t\\f\\v \"]+)|(?:\"([^\\r\\n\\t\\f\\v \"]+)\"))$");

    public static String getVersionFromMetaData(List<String> metaData) {
        if (metaData == null || metaData.isEmpty()) {
            return null;
        }
        for (String md : metaData) {
            Matcher matcher = VERSION_PATTERN.matcher(md);
            if (!matcher.matches()) continue;
            String version = matcher.group(1);
            if (version == null) {
                version = matcher.group(2);
            }
            return version;
        }
        return null;
    }

    public static void parse(String exportPackageHeader, PackageConsumer packageConsumer) {
        int state = S_PACKAGE;
        int packageStart = 0;
        int metaDataStart = -1;
        String pckName = null;
        ArrayList<String> metaData = new ArrayList<String>();
        for (int i = 0; i < exportPackageHeader.length(); ++i) {
            char c = exportPackageHeader.charAt(i);
            if (state == S_PACKAGE) {
                if (c == ';') {
                    pckName = exportPackageHeader.substring(packageStart, i).trim();
                    metaDataStart = i + 1;
                    state = S_META_DATA_CONTENT;
                    continue;
                }
                if (c != ',') continue;
                pckName = exportPackageHeader.substring(packageStart, i).trim();
                packageConsumer.consumePackage(pckName, metaData);
                packageStart = i + 1;
                continue;
            }
            if (state == S_META_DATA_CONTENT) {
                if (c == '\"') {
                    state = S_META_DATA_CONTENT_QUOTED;
                    continue;
                }
                if (c == ';') {
                    metaData.add(exportPackageHeader.substring(metaDataStart, i));
                    metaDataStart = i + 1;
                    state = S_META_DATA_CONTENT;
                    continue;
                }
                if (c != ',') continue;
                metaData.add(exportPackageHeader.substring(metaDataStart, i));
                packageConsumer.consumePackage(pckName, metaData);
                packageStart = i + 1;
                metaDataStart = -1;
                metaData.clear();
                state = S_PACKAGE;
                continue;
            }
            if (state == S_META_DATA_CONTENT_QUOTED) {
                if (c != '\"') continue;
                state = S_META_DATA_CONTENT;
                continue;
            }
            throw new IllegalStateException("can not parse");
        }
        if (metaDataStart != -1) {
            metaData.add(exportPackageHeader.substring(metaDataStart));
        }
        if (state == S_PACKAGE && (pckName = exportPackageHeader.substring(packageStart).trim()).isEmpty()) {
            pckName = null;
        }
        if (pckName != null) {
            packageConsumer.consumePackage(pckName, metaData);
        }
    }

    public static interface PackageConsumer {
        public void consumePackage(String var1, List<String> var2);
    }
}

