/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bndly.common.app.provisioning.model.RunMode;
import org.bndly.common.json.model.JSMember;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSValue;

public class ProvisioningModel {
    private final List<RunMode> runModes;

    public ProvisioningModel(JSObject object) {
        ArrayList<RunMode> tmp = new ArrayList<RunMode>();
        Set members = object.getMembers();
        if (members != null) {
            for (JSMember member : members) {
                String runModeName = member.getName().getValue();
                JSValue value = member.getValue();
                if (!JSObject.class.isInstance(value)) continue;
                tmp.add(new RunMode(runModeName, (JSObject)value));
            }
        }
        this.runModes = Collections.unmodifiableList(tmp);
    }

    public ProvisioningModel(ProvisioningModel ... aggreagted) {
        LinkedHashMap<String, ArrayList<RunMode>> runModesByName = new LinkedHashMap<String, ArrayList<RunMode>>();
        for (ProvisioningModel item : aggreagted) {
            for (RunMode runMode : item.getRunModes()) {
                ArrayList<RunMode> runModesTmp = (ArrayList<RunMode>)runModesByName.get(runMode.getName());
                if (runModesTmp == null) {
                    runModesTmp = new ArrayList<RunMode>();
                    runModesByName.put(runMode.getName(), runModesTmp);
                }
                runModesTmp.add(runMode);
            }
        }
        ArrayList<RunMode> runModesTmp = new ArrayList<RunMode>();
        for (Map.Entry entry : runModesByName.entrySet()) {
            runModesTmp.add(new RunMode((String)entry.getKey(), ((List)entry.getValue()).toArray(new RunMode[((List)entry.getValue()).size()])));
        }
        this.runModes = Collections.unmodifiableList(runModesTmp);
    }

    public JSObject toJsValue() {
        JSObject jsObject = new JSObject();
        for (RunMode runMode : this.getRunModes()) {
            JSMember member = jsObject.createMember(runMode.getName());
            member.setValue((JSValue)runMode.toJsValue());
        }
        return jsObject;
    }

    public List<RunMode> getRunModes() {
        return this.runModes;
    }
}

