/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.json.model.JSArray;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSString;
import org.bndly.common.json.model.JSValue;

public class ResourceDefinition {
    private final String source;
    private final String target;
    private final boolean unpack;
    private final List<String> includes;
    private final List<String> excludes;
    private final List<ArtifactDefinition> artifacts;

    ResourceDefinition(JSObject resourceDef) {
        ArrayList<Object> tmp;
        this.source = resourceDef.getMemberStringValue("source");
        this.target = resourceDef.getMemberStringValue("target");
        JSArray artifactsTmp = (JSArray)resourceDef.getMemberValue("artifacts", JSArray.class);
        if (artifactsTmp != null) {
            Boolean unpackTmp = resourceDef.getMemberBooleanValue("unpack");
            this.unpack = unpackTmp == null ? false : unpackTmp;
            tmp = new ArrayList<Object>();
            for (JSValue artifactDefString : artifactsTmp) {
                if (!JSString.class.isInstance(artifactDefString)) continue;
                tmp.add(new ArtifactDefinition(((JSString)artifactDefString).getValue()));
            }
            this.artifacts = Collections.unmodifiableList(tmp);
        } else {
            this.artifacts = Collections.EMPTY_LIST;
            this.unpack = false;
        }
        JSArray includesTmp = (JSArray)resourceDef.getMemberValue("includes", JSArray.class);
        if (includesTmp != null) {
            tmp = new ArrayList();
            for (JSValue include : includesTmp) {
                if (!JSString.class.isInstance(include)) continue;
                tmp.add(((JSString)include).getValue());
            }
            this.includes = Collections.unmodifiableList(tmp);
        } else {
            this.includes = Collections.EMPTY_LIST;
        }
        JSArray excludesTmp = (JSArray)resourceDef.getMemberValue("excludes", JSArray.class);
        if (excludesTmp != null) {
            ArrayList<String> tmp2 = new ArrayList<String>();
            for (JSValue exclude : excludesTmp) {
                if (!JSString.class.isInstance(exclude)) continue;
                tmp2.add(((JSString)exclude).getValue());
            }
            this.excludes = Collections.unmodifiableList(tmp2);
        } else {
            this.excludes = Collections.EMPTY_LIST;
        }
    }

    public JSValue toJsValue() {
        JSObject jsValue = new JSObject();
        if (this.source != null) {
            jsValue.createMember("source").setValue((JSValue)new JSString(this.source));
        }
        jsValue.createMember("target").setValue((JSValue)new JSString(this.target));
        if (!this.artifacts.isEmpty()) {
            JSArray artifactDefinitions = new JSArray();
            for (ArtifactDefinition artifact : this.artifacts) {
                artifactDefinitions.add((JSValue)new JSString(artifact.toString()));
            }
            jsValue.createMember("artifacts").setValue((JSValue)artifactDefinitions);
        }
        if (!this.includes.isEmpty()) {
            JSArray includeDefinitions = new JSArray();
            for (String include : this.includes) {
                includeDefinitions.add((JSValue)new JSString(include));
            }
            jsValue.createMember("includes").setValue((JSValue)includeDefinitions);
        }
        if (!this.excludes.isEmpty()) {
            JSArray excludeDefinitions = new JSArray();
            for (String exclude : this.excludes) {
                excludeDefinitions.add((JSValue)new JSString(exclude));
            }
            jsValue.createMember("excludes").setValue((JSValue)excludeDefinitions);
        }
        return jsValue;
    }

    public boolean isUnpack() {
        return this.unpack;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<ArtifactDefinition> getArtifacts() {
        return this.artifacts;
    }
}

