/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.model.Config;
import org.bndly.common.app.provisioning.model.ResourceDefinition;
import org.bndly.common.app.provisioning.model.StartLevelBundle;
import org.bndly.common.json.model.JSArray;
import org.bndly.common.json.model.JSMember;
import org.bndly.common.json.model.JSObject;
import org.bndly.common.json.model.JSString;
import org.bndly.common.json.model.JSValue;

public class RunMode {
    private final String name;
    private final List<StartLevelBundle> bundles;
    private final List<Config> configs;
    private final List<ResourceDefinition> resources;

    RunMode(String runModeName, JSObject jsObject) {
        this.bundles = this.initBundles(jsObject.getMember("bundles"));
        this.configs = this.initConfigs(jsObject.getMember("configs"));
        this.resources = this.initResources(jsObject.getMember("resources"));
        this.name = runModeName;
    }

    RunMode(String runModeName, RunMode ... aggregated) {
        ArrayList<StartLevelBundle> bundlesTmp = new ArrayList<StartLevelBundle>();
        ArrayList<Config> configsTmp = new ArrayList<Config>();
        ArrayList<ResourceDefinition> resourcesTmp = new ArrayList<ResourceDefinition>();
        for (RunMode runMode : aggregated) {
            bundlesTmp.addAll(runMode.getBundles());
            configsTmp.addAll(runMode.getConfigs());
            resourcesTmp.addAll(runMode.getResources());
        }
        this.bundles = Collections.unmodifiableList(bundlesTmp);
        this.configs = Collections.unmodifiableList(configsTmp);
        this.resources = Collections.unmodifiableList(resourcesTmp);
        this.name = runModeName;
    }

    public JSObject toJsValue() {
        JSObject jsValue = new JSObject();
        if (!this.getBundles().isEmpty()) {
            JSObject bundles = new JSObject();
            for (StartLevelBundle startLevelBundle : this.getBundles()) {
                JSArray artifacts = new JSArray();
                for (ArtifactDefinition artifactDefinition : startLevelBundle.getArtifacts()) {
                    artifacts.add((JSValue)new JSString(artifactDefinition.toString()));
                }
                bundles.createMember(String.valueOf(startLevelBundle.getStartLevel())).setValue((JSValue)artifacts);
            }
            jsValue.createMember("bundles").setValue((JSValue)bundles);
        }
        if (!this.getConfigs().isEmpty()) {
            JSObject configs = new JSObject();
            for (Config config : this.getConfigs()) {
                configs.createMember(config.getName()).setValue(config.toJsValue());
            }
            jsValue.createMember("configs").setValue((JSValue)configs);
        }
        if (!this.getResources().isEmpty()) {
            JSArray resources = new JSArray();
            for (ResourceDefinition resourceDefinition : this.getResources()) {
                resources.add(resourceDefinition.toJsValue());
            }
            jsValue.createMember("resources").setValue((JSValue)resources);
        }
        return jsValue;
    }

    private List<StartLevelBundle> initBundles(JSMember member) {
        if (member == null) {
            return Collections.EMPTY_LIST;
        }
        JSValue val = member.getValue();
        if (!JSObject.class.isInstance(val)) {
            return Collections.EMPTY_LIST;
        }
        Set startLevelMembers = ((JSObject)val).getMembers();
        if (startLevelMembers == null || startLevelMembers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartLevelBundle> tmp = new ArrayList<StartLevelBundle>();
        for (JSMember startLevelMember : startLevelMembers) {
            JSArray arr;
            int startLevel = Integer.valueOf(startLevelMember.getName().getValue());
            if (!JSArray.class.isInstance(startLevelMember.getValue()) || (arr = (JSArray)startLevelMember.getValue()).size() == 0) continue;
            StartLevelBundle startLevelBundle = new StartLevelBundle(startLevel, arr);
            tmp.add(startLevelBundle);
        }
        return Collections.unmodifiableList(tmp);
    }

    private List<Config> initConfigs(JSMember member) {
        if (member == null) {
            return Collections.EMPTY_LIST;
        }
        JSValue val = member.getValue();
        if (!JSObject.class.isInstance(val)) {
            return Collections.EMPTY_LIST;
        }
        Set configEntries = ((JSObject)val).getMembers();
        if (configEntries == null || configEntries.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Config> tmp = new ArrayList<Config>();
        for (JSMember configEntry : configEntries) {
            String configName = configEntry.getName().getValue();
            if (!JSObject.class.isInstance(configEntry.getValue())) continue;
            JSObject properties = (JSObject)configEntry.getValue();
            Config config = new Config(configName, properties);
            tmp.add(config);
        }
        return Collections.unmodifiableList(tmp);
    }

    private List<ResourceDefinition> initResources(JSMember member) {
        if (member == null) {
            return Collections.EMPTY_LIST;
        }
        JSValue val = member.getValue();
        if (!JSArray.class.isInstance(val)) {
            return Collections.EMPTY_LIST;
        }
        JSArray defs = (JSArray)val;
        if (defs.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResourceDefinition> tmp = new ArrayList<ResourceDefinition>();
        for (JSValue def : defs) {
            if (!JSObject.class.isInstance(def)) continue;
            JSObject resourceDef = (JSObject)def;
            tmp.add(new ResourceDefinition(resourceDef));
        }
        return Collections.unmodifiableList(tmp);
    }

    public String getName() {
        return this.name;
    }

    public List<StartLevelBundle> getBundles() {
        return this.bundles;
    }

    public List<Config> getConfigs() {
        return this.configs;
    }

    public List<ResourceDefinition> getResources() {
        return this.resources;
    }
}

