/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.util;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.bndly.common.app.provisioning.model.ArtifactDefinition;
import org.bndly.common.app.provisioning.util.ArtifactHelper;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class ArtifactHelperImpl
implements ArtifactHelper {
    private final ArtifactResolver resolver;
    private final MavenSession mavenSession;
    private final MavenProject project;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final ArchiverManager archiverManager;

    public ArtifactHelperImpl(ArtifactResolver resolver, MavenSession mavenSession, MavenProject project, ArtifactHandlerManager artifactHandlerManager, ArchiverManager archiverManager) {
        if (resolver == null) {
            throw new IllegalArgumentException("resolver is not allowed to be null");
        }
        this.resolver = resolver;
        this.mavenSession = mavenSession;
        this.project = project;
        this.artifactHandlerManager = artifactHandlerManager;
        if (archiverManager == null) {
            throw new IllegalArgumentException("archiverManager is not allowed to be null");
        }
        this.archiverManager = archiverManager;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArtifactHandlerManager getArtifactHandlerManager() {
        return this.artifactHandlerManager;
    }

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    @Override
    public final Path resolvePathToArtifact(ArtifactDefinition artifact) throws MojoExecutionException {
        Artifact mavenArtifact = this.loadArtifact(artifact);
        File file = mavenArtifact.getFile();
        if (file == null) {
            throw new MojoExecutionException("could not resolve path to artifact " + artifact);
        }
        return file.toPath();
    }

    @Override
    public final Artifact resolveArtifact(Artifact artifact) throws MojoExecutionException {
        Artifact found;
        if (artifact.getFile() == null && artifact.isResolved() && (found = this.mavenSession.getLocalRepository().find(artifact)) != null && found.getFile() != null) {
            return found;
        }
        ArtifactResolutionResult result = this.resolver.resolve(new ArtifactResolutionRequest().setArtifact(artifact).setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setLocalRepository(this.mavenSession.getLocalRepository()));
        List exceptions = result.getExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            throw new MojoExecutionException("could not resolve artifact", (Exception)exceptions.get(0));
        }
        Set resultArtifacts = result.getArtifacts();
        if (resultArtifacts.isEmpty()) {
            throw new MojoExecutionException("could not find artifact: " + this.artifactToString(artifact));
        }
        return (Artifact)resultArtifacts.iterator().next();
    }

    private String artifactToString(Artifact artifact) {
        return String.format("%s:%s:%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersion());
    }

    @Override
    public final Artifact loadArtifact(ArtifactDefinition artifact) throws MojoExecutionException {
        Set dependencies = this.project.getDependencyArtifacts();
        if (dependencies != null) {
            for (Artifact dependency : dependencies) {
                if (!this.dependencyMatchesArtifactDefinition(dependency, artifact)) continue;
                return this.resolveArtifact(dependency);
            }
        }
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        String type = artifact.getPackaging();
        String classifier = artifact.getClassifier();
        DefaultArtifact prjArtifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "provided", type, classifier, this.artifactHandlerManager.getArtifactHandler(type));
        return this.resolveArtifact((Artifact)prjArtifact);
    }

    public final boolean dependencyMatchesArtifactDefinition(Artifact dependency, ArtifactDefinition artifact) {
        return dependency.getGroupId().equals(artifact.getGroupId()) && dependency.getArtifactId().equals(artifact.getArtifactId()) && dependency.getVersion().equals(artifact.getVersion()) && (dependency.getType() == null && artifact.getPackaging() == null || dependency.getType() != null && dependency.getType().equals(artifact.getPackaging())) && (dependency.getClassifier() == null && artifact.getClassifier() == null || dependency.getClassifier() != null && dependency.getClassifier().equals(artifact.getClassifier()));
    }

    public static String toString(Dependency dependency) {
        StringBuilder sb = new StringBuilder();
        sb.append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":").append(dependency.getType());
        if (dependency.getClassifier() != null) {
            sb.append(":").append(dependency.getClassifier());
        }
        sb.append(":").append(dependency.getVersion());
        return sb.toString();
    }

    @Override
    public Path getProjectBaseDirPath() {
        return this.project.getBasedir().toPath();
    }

    @Override
    public UnArchiver getUnArchiver(File file) throws NoSuchArchiverException {
        return this.getArchiverManager().getUnArchiver(file);
    }
}

