/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.app.provisioning.mojo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.bndly.common.app.provisioning.model.ProvisioningModel;
import org.bndly.common.app.provisioning.mojo.AbstractProvisioningMojo;
import org.bndly.common.app.provisioning.mojo.PackageLayout;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.NONE, threadSafe=false)
public class PackageMojo
extends AbstractProvisioningMojo {
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        ProvisioningModel provisioningModel = (ProvisioningModel)this.project.getContextValue("bndly-application:provisioning");
        if (provisioningModel == null) {
            throw new MojoExecutionException("missing the provisioning model in the project context");
        }
        this.getLog().info((CharSequence)"got the loaded provisioning model");
        if (this.packageLayout == PackageLayout.springboot) {
            Manifest manifest;
            this.getLog().info((CharSequence)"adding osgi bundles, configs and resources to spring boot application package");
            Artifact projectArtifact = this.project.getArtifact();
            if (projectArtifact == null || !"jar".equals(projectArtifact.getType())) {
                throw new MojoExecutionException("could not find jar artifact for project");
            }
            File artifactFile = projectArtifact.getFile();
            if (artifactFile == null) {
                throw new MojoExecutionException("no file attached to project artifact");
            }
            try (JarFile jf = new JarFile(artifactFile);){
                manifest = jf.getManifest();
            }
            catch (IOException e) {
                throw new MojoExecutionException("failed to get manifest from original artifact", (Exception)e);
            }
            try {
                Path fileInfoFile;
                this.jarArchiver.reset();
                this.jarArchiver.setCompress(false);
                File tempFileForExpandedData = FileUtils.createTempFile((String)"sbo-zip", (String)".tmp", (File)artifactFile.getParentFile());
                tempFileForExpandedData.deleteOnExit();
                this.jarArchiver.setDestFile(tempFileForExpandedData);
                Path copyArtifact = artifactFile.toPath().getParent().resolve(this.createFileNameOfArtifactCopy(artifactFile));
                Files.deleteIfExists(copyArtifact);
                Files.copy(artifactFile.toPath(), copyArtifact, new CopyOption[0]);
                this.jarArchiver.addArchivedFileSet(copyArtifact.toFile());
                Path javaMain = this.getTargetJavaMainFolder();
                this.jarArchiver.addDirectory(javaMain.toFile());
                Path targetAppFolder = this.getTargetAppFolder();
                this.jarArchiver.addDirectory(targetAppFolder.toFile(), "SBO-INF" + File.separator);
                Path provisioningFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("prov").resolve("provisioning-model.json");
                if (Files.isRegularFile(provisioningFile, new LinkOption[0])) {
                    this.jarArchiver.addFile(provisioningFile.toFile(), "SBO-INF" + File.separator + "provisioning-model.json");
                }
                if (Files.isRegularFile(fileInfoFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("file-info.properties"), new LinkOption[0])) {
                    this.jarArchiver.addFile(fileInfoFile.toFile(), "SBO-INF" + File.separator + "file-info.properties");
                }
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    manifest.write(bos);
                    bos.flush();
                    org.codehaus.plexus.archiver.jar.Manifest plexusManifest = new org.codehaus.plexus.archiver.jar.Manifest((InputStream)new ByteArrayInputStream(bos.toByteArray()));
                    this.jarArchiver.addConfiguredManifest(plexusManifest);
                }
                catch (ManifestException e) {
                    throw new MojoExecutionException("failed to copy manifest", (Exception)((Object)e));
                }
                this.jarArchiver.createArchive();
                Files.deleteIfExists(artifactFile.toPath());
                Files.move(tempFileForExpandedData.toPath(), artifactFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to create standalone jar", (Exception)ioe);
            }
            return;
        }
        this.getLog().info((CharSequence)"Packaging standalone jar...");
        Path jarPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.project.getBuild().getFinalName());
        if (!jarPath.getFileName().endsWith(".jar")) {
            jarPath = Paths.get(jarPath.toString() + ".jar", new String[0]);
        }
        if (Files.notExists(jarPath.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(jarPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not create output directory", (Exception)ex);
            }
        }
        try {
            this.jarArchiver.reset();
            this.jarArchiver.setDestFile(jarPath.toFile());
            try (InputStream is = Files.newInputStream(this.getManifestPath(), StandardOpenOption.READ);){
                Path fileInfoFile;
                org.codehaus.plexus.archiver.jar.Manifest manifest = new org.codehaus.plexus.archiver.jar.Manifest(is);
                this.jarArchiver.addConfiguredManifest(manifest);
                Path javaMain = this.getTargetJavaMainFolder();
                this.jarArchiver.addDirectory(javaMain.toFile());
                Path targetAppFolder = this.getTargetAppFolder();
                this.jarArchiver.addDirectory(targetAppFolder.toFile(), "resources" + File.separator);
                Path provisioningFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("prov").resolve("provisioning-model.json");
                if (Files.isRegularFile(provisioningFile, new LinkOption[0])) {
                    this.jarArchiver.addFile(provisioningFile.toFile(), "provisioning-model.json");
                }
                if (Files.isRegularFile(fileInfoFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("file-info.properties"), new LinkOption[0])) {
                    this.jarArchiver.addFile(fileInfoFile.toFile(), "file-info.properties");
                }
            }
            catch (ManifestException ex) {
                throw new MojoExecutionException("could not add manifest to jar", (Exception)((Object)ex));
            }
            this.jarArchiver.createArchive();
            if ("bndly-application".equals(this.project.getPackaging())) {
                this.project.getArtifact().setFile(jarPath.toFile());
            } else {
                String artifactType = "jar";
                String artifactClassifier = "app";
                this.projectHelper.attachArtifact(this.project, artifactType, artifactClassifier, jarPath.toFile());
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to create standalone jar", (Exception)ioe);
        }
    }

    private String createFileNameOfArtifactCopy(File artifactFile) {
        String fileName = artifactFile.getName();
        int i = fileName.lastIndexOf(".");
        return fileName.substring(0, i) + ".copy" + fileName.substring(i);
    }
}

