/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.code.model;

import java.util.ArrayList;
import java.util.List;
import org.bndly.code.model.XMLAttribute;
import org.bndly.code.model.XMLObject;

public class XMLElement
extends XMLObject {
    private XMLElement parent;
    private List<XMLElement> elements;
    private List<XMLAttribute> attributes;

    public XMLElement() {
    }

    public XMLElement(String name) {
        this.setName(name);
    }

    public XMLElement(String name, String ns) {
        this.setName(name);
        this.setNamespacePrefix(ns);
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public List<XMLElement> getElements() {
        return this.elements;
    }

    public void setElements(List<XMLElement> elements) {
        this.elements = elements;
    }

    public List<XMLAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<XMLAttribute> attributes) {
        this.attributes = attributes;
    }

    public void add(XMLAttribute att) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<XMLAttribute>();
        }
        this.attributes.add(att);
    }

    public void add(XMLElement el) {
        if (this.elements == null) {
            this.elements = new ArrayList<XMLElement>();
        }
        this.elements.add(el);
        el.parent = this;
    }

    public XMLAttribute createAttribute() {
        XMLAttribute att = (XMLAttribute)this.create(XMLAttribute.class);
        this.add(att);
        return att;
    }

    public XMLAttribute createAttribute(String name, String namespacePrefix, String value) {
        XMLAttribute att = this.createAttribute();
        att.setName(name);
        att.setNamespacePrefix(namespacePrefix);
        att.setValue(value);
        return att;
    }

    public XMLAttribute createAttribute(String name, String value) {
        XMLAttribute att = this.createAttribute();
        att.setName(name);
        att.setValue(value);
        return att;
    }

    public XMLElement createElement() {
        XMLElement el = (XMLElement)this.create(XMLElement.class);
        this.add(el);
        return el;
    }

    public XMLElement createElement(String name) {
        XMLElement el = this.createElement();
        el.setName(name);
        return el;
    }

    public XMLElement createElement(String name, String namespacePrefix) {
        XMLElement el = this.createElement(name);
        el.setNamespacePrefix(namespacePrefix);
        return el;
    }

    public XMLAttribute getAttribute(String name) {
        if (this.attributes != null && name != null) {
            for (XMLAttribute att : this.attributes) {
                if (!name.equals(att.getName())) continue;
                return att;
            }
        }
        return null;
    }
}

