/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.code.output;

import java.util.List;
import org.bndly.code.common.CodeGenerationObject;
import org.bndly.code.model.CodeBlock;
import org.bndly.code.model.CodeBlockIndented;
import org.bndly.code.model.CodeLine;
import org.bndly.code.model.XMLAttribute;
import org.bndly.code.model.XMLElement;

public class XMLCodeWriter
extends CodeGenerationObject {
    public CodeBlock toCode(XMLElement el) {
        CodeBlock block = (CodeBlock)this.create(CodeBlock.class);
        block.createContained(CodeLine.class, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.handleElementInBlock(el, block);
        return block;
    }

    private void handleElementInBlock(XMLElement el, CodeBlock block) {
        List<XMLElement> subElements = el.getElements();
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        String elementName = el.getName();
        if (el.getNamespacePrefix() != null) {
            elementName = el.getNamespacePrefix() + ":" + elementName;
        }
        sb.append(elementName);
        List<XMLAttribute> attributes = el.getAttributes();
        if (attributes != null) {
            for (XMLAttribute xmlAttribute : attributes) {
                sb.append(" ");
                if (xmlAttribute.getNamespacePrefix() != null) {
                    sb.append(xmlAttribute.getNamespacePrefix());
                    sb.append(":");
                }
                sb.append(xmlAttribute.getName());
                sb.append("=\"");
                if (xmlAttribute.getValue() != null) {
                    sb.append(xmlAttribute.getValue());
                }
                sb.append("\"");
            }
        }
        if (subElements != null) {
            sb.append(">");
        } else {
            sb.append("/>");
        }
        block.createContained(CodeLine.class, sb.toString());
        if (subElements != null) {
            CodeBlockIndented subElementBlock = block.createContained(CodeBlockIndented.class);
            for (XMLElement subEl : subElements) {
                this.handleElementInBlock(subEl, subElementBlock);
            }
            block.createContained(CodeLine.class, "</" + elementName + ">");
        }
    }
}

