/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.code.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.bndly.code.model.XMLAttribute;
import org.bndly.code.model.XMLElement;
import org.bndly.code.output.XMLIllegalCharacterException;

public class XMLWriter {
    public void write(XMLElement el, OutputStream os) throws IOException {
        this.write(el, os, "UTF-8");
    }

    public void write(XMLElement el, OutputStream os, String encoding) throws IOException {
        this.write(el, new OutputStreamWriter(os, encoding));
    }

    public void write(XMLElement el, Writer writer) throws IOException {
        this.writeElement(el, writer);
        writer.flush();
    }

    private void writeElement(XMLElement el, Writer writer) throws IOException {
        String name;
        if (el != null && (name = el.getName()) != null) {
            List<XMLElement> children;
            writer.write(60);
            String ns = el.getNamespacePrefix();
            if (ns != null) {
                writer.write(ns);
                writer.write(":");
            }
            this.writeName(name, writer);
            List<XMLAttribute> attributes = el.getAttributes();
            if (attributes != null) {
                for (XMLAttribute xMLAttribute : attributes) {
                    writer.write(32);
                    this.writeAttribute(xMLAttribute, writer);
                }
            }
            if ((children = el.getElements()) != null && !children.isEmpty()) {
                writer.write(">");
                for (XMLElement xMLElement : children) {
                    this.write(xMLElement, writer);
                }
                writer.write("</");
                if (ns != null) {
                    writer.write(ns);
                    writer.write(":");
                }
                this.writeName(name, writer);
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private void writeAttribute(XMLAttribute xMLAttribute, Writer writer) throws IOException {
        String name;
        if (xMLAttribute != null && (name = xMLAttribute.getName()) != null) {
            String ns = xMLAttribute.getNamespacePrefix();
            if (ns != null) {
                writer.write(ns);
                writer.write(":");
            }
            this.writeName(name, writer);
            String value = xMLAttribute.getValue();
            if (value != null) {
                writer.write("=\"");
                this.writeContentEscaped(value, writer);
                writer.write("\"");
            }
        }
    }

    private void writeContentEscaped(String content, Writer writer) throws IOException {
        for (int i = 0; i < content.length(); ++i) {
            char character = content.charAt(i);
            if (character == '\"') {
                writer.append("&quot;");
                continue;
            }
            if (character == '&') {
                writer.append("&amp;");
                continue;
            }
            if (character == '<') {
                writer.append("&lt;");
                continue;
            }
            if (character == '>') {
                writer.append("&gt;");
                continue;
            }
            writer.append(character);
        }
    }

    private void writeName(String name, Writer writer) throws IOException {
        boolean isStart = true;
        for (int index = 0; index < name.length(); ++index) {
            char character = name.charAt(index);
            if (isStart) {
                if (this.isNameStartChar(character)) {
                    writer.append(character);
                    isStart = false;
                    continue;
                }
                throw new XMLIllegalCharacterException("invalid start character for xml name.");
            }
            if (this.isNameChar(character)) {
                writer.append(character);
                continue;
            }
            throw new XMLIllegalCharacterException("invalid character for xml name.");
        }
    }

    private boolean isNameStartChar(char character) {
        if (character == ':') {
            return true;
        }
        if (character >= 'A' && character <= 'Z') {
            return true;
        }
        if (character == '_') {
            return true;
        }
        if (character >= 'a' && character <= 'z') {
            return true;
        }
        if (character >= '\u00c0' && character <= '\u00d6') {
            return true;
        }
        if (character >= '\u00d8' && character <= '\u00f6') {
            return true;
        }
        if (character >= '\u00f8' && character <= '\u02ff') {
            return true;
        }
        if (character >= '\u0370' && character <= '\u037d') {
            return true;
        }
        if (character >= '\u037f' && character <= '\u1fff') {
            return true;
        }
        if (character >= '\u200c' && character <= '\u200d') {
            return true;
        }
        if (character >= '\u2070' && character <= '\u218f') {
            return true;
        }
        if (character >= '\u2c00' && character <= '\u2fef') {
            return true;
        }
        if (character >= '\u3001' && character <= '\ud7ff') {
            return true;
        }
        if (character >= '\uf900' && character <= '\ufdcf') {
            return true;
        }
        if (character >= '\ufdf0' && character <= '\ufffd') {
            return true;
        }
        return character >= '\u10000' && character <= '\ueffff';
    }

    private boolean isNameChar(char character) {
        if (this.isNameStartChar(character)) {
            return true;
        }
        if (character == '-') {
            return true;
        }
        if (character == '.') {
            return true;
        }
        if (character >= '0' && character <= '9') {
            return true;
        }
        if (character == '\u00b7') {
            return true;
        }
        if (character >= '\u0300' && character <= '\u036f') {
            return true;
        }
        return character >= '\u203f' && character <= '\u2040';
    }
}

