/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.event.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bndly.common.event.api.ApplicationContextResolver;
import org.bndly.common.event.api.EventBus;
import org.bndly.common.event.api.ListenerIterator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={EventBus.class}, immediate=true)
public class EventBusImpl
implements EventBus {
    private final Map<Class<?>, List<Object>> listeners = new HashMap();
    @Reference
    private ApplicationContextResolver applicationContextResolver;

    public <E> void registerEvent(Class<E> eventInterfaceType) {
        if (this.applicationContextResolver != null) {
            List list = this.applicationContextResolver.resolveObjectsOfType(eventInterfaceType);
            if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            this.listeners.put(eventInterfaceType, list);
        }
    }

    public <E> void fireEvent(Class<E> eventInterfaceType, ListenerIterator<E> iterator) {
        List<Object> list = this.listeners.get(eventInterfaceType);
        if (list != null) {
            for (Object object : list) {
                iterator.fireEvent(object);
            }
        }
    }

    public void setApplicationContextResolver(ApplicationContextResolver applicationContextResolver) {
        this.applicationContextResolver = applicationContextResolver;
    }
}

