/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.event.impl;

import java.util.ArrayList;
import java.util.List;
import org.bndly.common.event.api.ApplicationContextResolver;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ApplicationContextResolver.class}, immediate=true)
public class OSGIApplicationContextResolver
implements ApplicationContextResolver {
    private ComponentContext componentContext;

    @Activate
    public void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    @Deactivate
    public void deactivate() {
        this.componentContext = null;
    }

    public <E> List<E> resolveObjectsOfType(Class<E> type) {
        Object[] services = this.componentContext.locateServices(type.getName());
        ArrayList<Object> result = null;
        if (services != null) {
            for (Object service : services) {
                if (!type.isInstance(service)) continue;
                if (result == null) {
                    result = new ArrayList<Object>();
                }
                result.add(service);
            }
        }
        return result;
    }
}

