/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.mail.impl;

import org.bndly.common.mail.api.Configuration;
import org.bndly.common.mail.api.EmailAddress;
import org.bndly.common.osgi.util.DictionaryAdapter;

public class DictionaryAdapterBasedConfigurationImpl
implements Configuration {
    protected static final String SENDER_ADDRESS = "senderAddress";
    protected static final String DEBUG = "debug";
    protected static final String HOST = "host";
    protected static final String PASSWORD = "password";
    protected static final String USER = "user";
    protected static final String PORT = "port";
    protected static final String CONNECTION_TIMEOUT = "connectionTimeout";
    protected static final String READ_TIMEOUT = "readTimeout";
    protected static final String WRITE_TIMEOUT = "writeTimeout";
    protected static final String FROM = "from";
    protected static final String LOCALHOST = "localhost";
    protected static final String LOCAL_ADDRESS = "localAddress";
    protected static final String LOCAL_PORT = "localPort";
    protected static final String EHLO = "ehlo";
    protected static final String AUTH = "auth";
    protected static final String SUBMITTER = "submitter";
    protected static final String DSN_NOTIFY = "dsnNotify";
    protected static final String DSN_RET = "dsnRet";
    protected static final String ALLOW8_BIT_MIME = "allow8BitMime";
    protected static final String SEND_PARTIAL = "sendPartial";
    protected static final String SASL_ENABLE = "saslEnable";
    protected static final String SASL_MECHANISMS = "saslMechanisms";
    protected static final String SASL_AUTHORIZATION_ID = "saslAuthorizationId";
    protected static final String SASL_REALM = "saslRealm";
    protected static final String SASL_USE_CANONICAL_HOST_NAME = "saslUseCanonicalHostName";
    protected static final String QUIT_WAIT = "quitWait";
    protected static final String REPORT_SUCCESS = "reportSuccess";
    protected static final String SOCKET_FACTORY_CLASS = "socketFactoryClass";
    protected static final String SOCKET_FACTORY_FALLBACK = "socketFactoryFallback";
    protected static final String SOCKET_FACTORY_PORT = "socketFactoryPort";
    protected static final String SSL_ENABLE = "sslEnable";
    protected static final String SSL_CHECK_SERVER_IDENTITY = "sslCheckServerIdentity";
    protected static final String SSL_TRUST = "sslTrust";
    protected static final String SSL_SOCKET_FACTORY_CLASS = "sslSocketFactoryClass";
    protected static final String SSL_SOCKET_FACTORY_PORT = "sslSocketFactoryPort";
    protected static final String SSL_PROTOCOLS = "sslProtocols";
    protected static final String SSL_CIPHER_SUITES = "sslCipherSuites";
    protected static final String START_TLS_ENABLE = "startTlsEnable";
    protected static final String START_TLS_REQUIRED = "startTlsRequired";
    protected static final String SOCKS_HOST = "socksHost";
    protected static final String SOCKS_PORT = "socksPort";
    protected static final String MAIL_EXTENSION = "mailExtension";
    protected static final String USER_SET = "userSet";
    protected static final String NO_OP_STRICT = "noOpStrict";
    private final DictionaryAdapter dictionaryAdapter;

    public DictionaryAdapterBasedConfigurationImpl(DictionaryAdapter dictionaryAdapter) {
        this.dictionaryAdapter = dictionaryAdapter.emptyStringAsNull();
    }

    public EmailAddress getSenderAdress() {
        String sa = this.dictionaryAdapter.getString(SENDER_ADDRESS);
        return sa != null ? new EmailAddress(sa) : null;
    }

    public Boolean getDebug() {
        return this.dictionaryAdapter.getBoolean(DEBUG);
    }

    public String getHost() {
        return this.dictionaryAdapter.getString(HOST);
    }

    public String getPassword() {
        return this.dictionaryAdapter.getString(PASSWORD);
    }

    public String getUser() {
        return this.dictionaryAdapter.getString(USER);
    }

    public Integer getPort() {
        return this.dictionaryAdapter.getInteger(PORT, Integer.valueOf(25));
    }

    public Integer getConnectionTimeout() {
        return this.dictionaryAdapter.getInteger(CONNECTION_TIMEOUT);
    }

    public Integer getReadTimeout() {
        return this.dictionaryAdapter.getInteger(READ_TIMEOUT);
    }

    public Integer getWriteTimeout() {
        return this.dictionaryAdapter.getInteger(WRITE_TIMEOUT);
    }

    public EmailAddress getFrom() {
        String from = this.dictionaryAdapter.getString(FROM);
        return from != null ? new EmailAddress(from) : null;
    }

    public String getLocalhost() {
        return this.dictionaryAdapter.getString(LOCALHOST);
    }

    public String getLocalAddress() {
        return this.dictionaryAdapter.getString(LOCAL_ADDRESS);
    }

    public Integer getLocalPort() {
        return this.dictionaryAdapter.getInteger(LOCAL_PORT);
    }

    public Boolean getEhlo() {
        return this.dictionaryAdapter.getBoolean(EHLO);
    }

    public Boolean getAuth() {
        return this.dictionaryAdapter.getBoolean(AUTH);
    }

    public String getSubmitter() {
        return this.dictionaryAdapter.getString(SUBMITTER);
    }

    public String getDSNNotify() {
        return this.dictionaryAdapter.getString(DSN_NOTIFY);
    }

    public String getDSNRet() {
        return this.dictionaryAdapter.getString(DSN_RET);
    }

    public Boolean getAllow8BitMime() {
        return this.dictionaryAdapter.getBoolean(ALLOW8_BIT_MIME);
    }

    public Boolean getSendPartial() {
        return this.dictionaryAdapter.getBoolean(SEND_PARTIAL);
    }

    public Boolean getSASLEnable() {
        return this.dictionaryAdapter.getBoolean(SASL_ENABLE);
    }

    public String getSASLMechanisms() {
        return this.dictionaryAdapter.getString(SASL_MECHANISMS);
    }

    public String getSASLAuthorizationId() {
        return this.dictionaryAdapter.getString(SASL_AUTHORIZATION_ID);
    }

    public String getSASLRealm() {
        return this.dictionaryAdapter.getString(SASL_REALM);
    }

    public Boolean getSASLUseCanonicalHostName() {
        return this.dictionaryAdapter.getBoolean(SASL_USE_CANONICAL_HOST_NAME);
    }

    public Boolean getQuitWait() {
        return this.dictionaryAdapter.getBoolean(QUIT_WAIT);
    }

    public Boolean getReportSuccess() {
        return this.dictionaryAdapter.getBoolean(REPORT_SUCCESS);
    }

    public String getSocketFactoryClass() {
        return this.dictionaryAdapter.getString(SOCKET_FACTORY_CLASS);
    }

    public Boolean getSocketFactoryFallback() {
        return this.dictionaryAdapter.getBoolean(SOCKET_FACTORY_FALLBACK);
    }

    public Integer getSocketFactoryPort() {
        return this.dictionaryAdapter.getInteger(SOCKET_FACTORY_PORT);
    }

    public Boolean getSSLEnable() {
        return this.dictionaryAdapter.getBoolean(SSL_ENABLE, Boolean.valueOf(false));
    }

    public Boolean getSSLCheckServerIdentity() {
        return this.dictionaryAdapter.getBoolean(SSL_CHECK_SERVER_IDENTITY);
    }

    public String getSSLTrust() {
        return this.dictionaryAdapter.getString(SSL_TRUST);
    }

    public String getSSLSocketFactoryClass() {
        return this.dictionaryAdapter.getString(SSL_SOCKET_FACTORY_CLASS);
    }

    public Integer getSSLSocketFactoryPort() {
        return this.dictionaryAdapter.getInteger(SSL_SOCKET_FACTORY_PORT);
    }

    public String getSSLProtocols() {
        return this.dictionaryAdapter.getString(SSL_PROTOCOLS);
    }

    public String getSSLCipherSuites() {
        return this.dictionaryAdapter.getString(SSL_CIPHER_SUITES);
    }

    public Boolean getStartTLSEnable() {
        return this.dictionaryAdapter.getBoolean(START_TLS_ENABLE);
    }

    public Boolean getStartTLSRequired() {
        return this.dictionaryAdapter.getBoolean(START_TLS_REQUIRED);
    }

    public String getSocksHost() {
        return this.dictionaryAdapter.getString(SOCKS_HOST);
    }

    public String getSocksPort() {
        return this.dictionaryAdapter.getString(SOCKS_PORT);
    }

    public String getMailExtension() {
        return this.dictionaryAdapter.getString(MAIL_EXTENSION);
    }

    public Boolean getUserSet() {
        return this.dictionaryAdapter.getBoolean(USER_SET);
    }

    public Boolean getNoOpStrict() {
        return this.dictionaryAdapter.getBoolean(NO_OP_STRICT);
    }
}

