/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.mail.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bndly.common.mail.api.Attachment;
import org.bndly.common.mail.api.Configuration;
import org.bndly.common.mail.api.EmailAddress;
import org.bndly.common.mail.api.Mail;
import org.bndly.common.mail.api.MailContent;
import org.bndly.common.mail.api.MailException;
import org.bndly.common.mail.api.MailTemplate;
import org.bndly.common.mail.api.MailWrapper;
import org.bndly.common.mail.api.Mailer;
import org.bndly.common.mail.api.MailerListener;
import org.bndly.common.mail.impl.AttachmentDataSource;
import org.bndly.common.mail.impl.DictionaryAdapterBasedConfigurationImpl;
import org.bndly.common.osgi.util.DictionaryAdapter;
import org.bndly.common.osgi.util.ServiceRegistrationBuilder;
import org.bndly.common.velocity.api.ContextData;
import org.bndly.common.velocity.api.Renderer;
import org.bndly.common.velocity.api.VelocityTemplate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=OSGIConfiguration.class)
public class MailerImpl
implements Mailer {
    private static final Logger LOG = LoggerFactory.getLogger(MailerImpl.class);
    private final Properties props = new Properties();
    private Configuration configuration;
    @Reference
    private Renderer renderer;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final List<MailerListener> listeners = new ArrayList<MailerListener>();
    private Authenticator authenticator;
    private BundleTracker<ClassLoader> mailImplBundleTracker;
    private ClassLoader mailImplClassLoader;
    private ServiceRegistration<Mailer> mailerReg;
    private static final String MIME_PREFIX_TEXT = "text/";

    @Activate
    public void activate(ComponentContext componentContext) {
        DictionaryAdapter dictionaryAdapter = new DictionaryAdapter(componentContext.getProperties());
        DictionaryAdapterBasedConfigurationImpl c = new DictionaryAdapterBasedConfigurationImpl(dictionaryAdapter);
        this.configure(c);
        final String mailImplBundleSymbolicName = dictionaryAdapter.getString("mailImplBundle", "com.sun.mail.javax.mail");
        this.mailImplBundleTracker = new BundleTracker<ClassLoader>(componentContext.getBundleContext(), 32, null){

            public ClassLoader addingBundle(Bundle bundle, BundleEvent event) {
                ClassLoader cl = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
                if (mailImplBundleSymbolicName.equals(bundle.getSymbolicName())) {
                    MailerImpl.this.mailImplClassLoader = cl;
                    if (MailerImpl.this.mailerReg == null) {
                        MailerImpl.this.mailerReg = ServiceRegistrationBuilder.newInstance(Mailer.class, (Object)MailerImpl.this).register(this.context);
                    }
                }
                return cl;
            }

            public void removedBundle(Bundle bundle, BundleEvent event, ClassLoader cl) {
                if (cl == MailerImpl.this.mailImplClassLoader) {
                    if (MailerImpl.this.mailerReg != null) {
                        MailerImpl.this.mailerReg.unregister();
                        MailerImpl.this.mailerReg = null;
                    }
                    MailerImpl.this.mailImplClassLoader = null;
                }
                super.removedBundle(bundle, event, (Object)cl);
            }
        };
        this.mailImplBundleTracker.open();
    }

    @Deactivate
    public void deactivate() {
        if (this.mailerReg != null) {
            this.mailerReg.unregister();
            this.mailerReg = null;
        }
        this.mailImplBundleTracker.close();
    }

    public void addMailerListener(MailerListener listener) {
        if (listener != null) {
            this.readWriteLock.writeLock().lock();
            try {
                this.listeners.add(listener);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    public void removeMailerListener(MailerListener listener) {
        if (listener != null) {
            this.readWriteLock.writeLock().lock();
            try {
                Iterator<MailerListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != listener) continue;
                    iterator.remove();
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    public MailContent renderTemplate(final MailTemplate template) throws MailException {
        OutputStreamWriter writer;
        final ByteArrayOutputStream bos = new ByteArrayOutputStream();
        VelocityTemplate vt = new VelocityTemplate();
        vt.setEntity(template.getEntity());
        vt.setLocale(template.getLocale());
        vt.setTemplateName(template.getTemplateName());
        if (template.getContextData() != null) {
            ArrayList<ContextData> cd = new ArrayList<ContextData>();
            vt.setContextData(cd);
            for (Map.Entry entry : template.getContextData().entrySet()) {
                String string = (String)entry.getKey();
                Object object = entry.getValue();
                ContextData data = new ContextData();
                data.setKey(string);
                data.setValue(object);
                cd.add(data);
            }
        }
        try {
            writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
        this.renderer.render(vt, (Writer)writer);
        try {
            writer.flush();
        }
        catch (IOException ex) {
            throw new MailException("could not render mail template: " + ex.getMessage(), (Throwable)ex);
        }
        return new MailContent(){

            public byte[] getData() {
                return bos.toByteArray();
            }

            public String getContentType() {
                return template.getContentType();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Mail mail) throws MailException {
        Object mailToUse;
        if (mail.getSender() == null) {
            final EmailAddress sa = this.configuration.getSenderAdress();
            if (sa == null) {
                throw new MailException("mail did not define a sender and the configuration of the mailer did not contain a default sender address");
            }
            mailToUse = new MailWrapper(mail){

                public EmailAddress getSender() throws MailException {
                    return sa;
                }
            };
        } else {
            mailToUse = mail;
        }
        MimeMessage message = this.buildMimeMessageFromMail((Mail)mailToUse);
        try {
            ClassLoader tmp = this.mailImplClassLoader;
            if (tmp != null) {
                ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(tmp);
                    Transport.send((Message)message);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ccl);
                }
            } else {
                Transport.send((Message)message);
            }
            this.readWriteLock.readLock().lock();
            try {
                for (MailerListener listener : this.listeners) {
                    listener.onMailSent(mailToUse);
                }
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        catch (AuthenticationFailedException ex) {
            this.readWriteLock.readLock().lock();
            try {
                for (MailerListener listener : this.listeners) {
                    listener.onAuthenticationFailure(mailToUse);
                }
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
            throw new MailException("failed to authenticate at the mail server", (Throwable)ex);
        }
        catch (MessagingException ex) {
            this.readWriteLock.readLock().lock();
            try {
                for (MailerListener listener : this.listeners) {
                    listener.onGenericFailure(mailToUse);
                    listener.onGenericFailure(mailToUse, ex);
                }
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
            throw new MailException("failed to send email: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void configure(Configuration configuration) {
        if (configuration != null) {
            this.configuration = configuration;
            this.reconfigure();
        }
    }

    private MimeMessage buildMimeMessageFromMail(Mail mail) throws MailException {
        Authenticator a = this.authenticator;
        Session session = a != null ? Session.getInstance((Properties)this.props, (Authenticator)a) : Session.getInstance((Properties)this.props);
        MimeMessage message = new MimeMessage(session);
        if (mail.getSubject() != null) {
            try {
                message.setSubject(mail.getSubject());
            }
            catch (MessagingException ex) {
                LOG.warn("could not set subject: " + ex.getMessage(), (Throwable)ex);
            }
        }
        InternetAddress from = this.internetAddress(mail.getSender());
        try {
            message.setFrom((Address)from);
        }
        catch (MessagingException ex) {
            throw new MailException("could not set 'from': " + ex.getMessage(), (Throwable)ex);
        }
        InternetAddress[] replyTo = new InternetAddress[]{};
        try {
            message.setReplyTo((Address[])replyTo);
        }
        catch (MessagingException ex) {
            throw new MailException("could not set 'replyTo': " + ex.getMessage(), (Throwable)ex);
        }
        this.addRecipients(message, mail.getTo(), Message.RecipientType.TO);
        this.addRecipients(message, mail.getBcc(), Message.RecipientType.BCC);
        try {
            message.setSentDate(new Date());
        }
        catch (MessagingException ex) {
            throw new MailException("could not set 'sentDate' " + replyTo.toString() + ": " + ex.getMessage(), (Throwable)ex);
        }
        MimeMultipart multipartContent = this.buildMimeMultipartContent(mail);
        List attachments = mail.getAttachments();
        if (attachments != null) {
            try {
                for (Attachment attachment : attachments) {
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    AttachmentDataSource source = new AttachmentDataSource(attachment);
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    mimeBodyPart.setFileName(attachment.getFileName());
                    multipartContent.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            catch (MessagingException ex) {
                throw new MailException("could not add attachment: " + ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            message.setContent((Multipart)multipartContent);
        }
        catch (MessagingException ex) {
            throw new MailException("could not set 'content': " + ex.getMessage(), (Throwable)ex);
        }
        return message;
    }

    private InternetAddress internetAddress(EmailAddress ea) {
        try {
            return new InternetAddress(ea.getValue());
        }
        catch (AddressException ex) {
            throw new IllegalStateException("could not create InternetAddress from EmailAddress-Value: " + ex.getMessage(), ex);
        }
    }

    private void addRecipients(MimeMessage message, List<EmailAddress> addresses, Message.RecipientType type) {
        if (addresses != null) {
            for (EmailAddress emailAddress : addresses) {
                InternetAddress add = this.internetAddress(emailAddress);
                try {
                    message.addRecipient(type, (Address)add);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("could not add 'recipient': " + ex.getMessage(), ex);
                }
            }
        }
    }

    private MimeMultipart buildMimeMultipartContent(Mail mail) throws MailException {
        MimeMultipart body = new MimeMultipart("mixed");
        List content = mail.getContent();
        if (content != null) {
            MimeBodyPart wrap = new MimeBodyPart();
            MimeMultipart bdy = new MimeMultipart("alternative");
            for (MailContent mailContent : content) {
                MimeBodyPart part;
                byte[] data = mailContent.getData();
                InternetHeaders headers = new InternetHeaders();
                String contentType = mailContent.getContentType();
                if (contentType == null) {
                    throw new MailException("missing content type in mail content");
                }
                headers.addHeader("Content-Type", contentType + ";charset=UTF-8;");
                if (contentType.startsWith(MIME_PREFIX_TEXT)) {
                    String mimeSubType = mailContent.getContentType().substring(MIME_PREFIX_TEXT.length());
                    try {
                        part = new MimeBodyPart();
                        part.setText(new String(data, "UTF-8"), "UTF-8", mimeSubType);
                    }
                    catch (UnsupportedEncodingException | MessagingException ex) {
                        throw new MailException("could not create MimeBodyPart: " + ex.getMessage(), ex);
                    }
                }
                try {
                    part = new MimeBodyPart(headers, data);
                }
                catch (MessagingException ex) {
                    throw new MailException("could not create MimeBodyPart: " + ex.getMessage(), (Throwable)ex);
                }
                try {
                    bdy.addBodyPart((BodyPart)part);
                }
                catch (MessagingException ex) {
                    throw new MailException("could not add MimeBodyPart: " + ex.getMessage(), (Throwable)ex);
                }
            }
            try {
                wrap.setContent((Multipart)bdy);
            }
            catch (MessagingException ex) {
                throw new MailException("could not set content of body wrapper: " + ex.getMessage(), (Throwable)ex);
            }
            try {
                body.addBodyPart((BodyPart)wrap);
            }
            catch (MessagingException ex) {
                throw new MailException("could not add body wrapper to mixed body: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return body;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private void reconfigure() {
        boolean doAuth;
        if (this.isEmpty(this.configuration.getUser()) && this.isEmpty(this.configuration.getPassword())) {
            this.authenticator = null;
            doAuth = false;
            LOG.info("configured mailer to not use an authenticator");
        } else {
            this.authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailerImpl.this.configuration.getUser(), MailerImpl.this.configuration.getPassword());
                }
            };
            doAuth = true;
            LOG.info("configured mailer to use an authenticator with a user and password");
        }
        if (this.configuration != null && this.props != null) {
            Boolean noOpStrict;
            Boolean userSet;
            String mailExtension;
            String socksPort;
            String socksHost;
            Boolean startTLSRequired;
            Boolean startTLSEnable;
            String sslCipherSuites;
            String sslProtocols;
            Integer sslSocketFactoryPort;
            String sslSocketFactoryClass;
            String sslTrust;
            Boolean sslCheckServerIdentity;
            Integer socketFactoryPort;
            Boolean socketFactoryFallback;
            String socketFactoryClass;
            Boolean reportSuccess;
            Boolean quitWait;
            Boolean saslUseCanonicalHostName;
            String saslRealm;
            String saslAuthorizationId;
            String saslMechanisms;
            Boolean saslEnable;
            Boolean sendPartial;
            Boolean allow8BitMime;
            String dsnRet;
            String dsnNotify;
            String submitter;
            Boolean ehlo;
            Integer localPort;
            String localAddress;
            String localhost;
            EmailAddress from;
            Integer writeTimeout;
            Integer readTimeout;
            Integer port;
            String host;
            Boolean secured = this.configuration.getSSLEnable();
            if (secured == null) {
                secured = false;
            }
            String mailPrefix = "mail.";
            String protocolPrefix = mailPrefix + "smtp.";
            if (secured.booleanValue()) {
                this.props.setProperty(mailPrefix + "transport.protocol", "smtps");
            } else {
                this.props.setProperty(mailPrefix + "transport.protocol", "smtp");
            }
            this.props.setProperty(protocolPrefix + "ssl.enable", Boolean.toString(secured));
            Boolean debug = this.configuration.getDebug();
            if (debug != null) {
                this.props.setProperty(mailPrefix + "debug", debug.toString());
            }
            if ((host = this.configuration.getHost()) != null) {
                this.props.setProperty(protocolPrefix + "host", host);
            }
            if ((port = this.configuration.getPort()) == null) {
                port = 25;
            }
            this.props.setProperty(protocolPrefix + "port", port.toString());
            if (doAuth) {
                this.props.setProperty(protocolPrefix + "auth", "true");
            } else {
                this.props.setProperty(protocolPrefix + "auth", "false");
            }
            Integer connectionTimeout = this.configuration.getConnectionTimeout();
            if (connectionTimeout != null) {
                this.props.setProperty(protocolPrefix + "connectiontimeout", connectionTimeout.toString());
            }
            if ((readTimeout = this.configuration.getReadTimeout()) != null) {
                this.props.setProperty(protocolPrefix + "timeout", readTimeout.toString());
            }
            if ((writeTimeout = this.configuration.getWriteTimeout()) != null) {
                this.props.setProperty(protocolPrefix + "writetimeout", writeTimeout.toString());
            }
            if ((from = this.configuration.getFrom()) != null) {
                this.props.setProperty(mailPrefix + "from", from.getValue());
            }
            if ((localhost = this.configuration.getLocalhost()) != null) {
                this.props.setProperty(protocolPrefix + "localhost", localhost);
            }
            if ((localAddress = this.configuration.getLocalAddress()) != null) {
                this.props.setProperty(protocolPrefix + "localaddress", localAddress);
            }
            if ((localPort = this.configuration.getLocalPort()) != null) {
                this.props.setProperty(protocolPrefix + "localport", localPort.toString());
            }
            if ((ehlo = this.configuration.getEhlo()) != null) {
                this.props.setProperty(protocolPrefix + "ehlo", ehlo.toString());
            }
            if ((submitter = this.configuration.getSubmitter()) != null) {
                this.props.setProperty(protocolPrefix + "submitter", submitter);
            }
            if ((dsnNotify = this.configuration.getDSNNotify()) != null) {
                this.props.setProperty(protocolPrefix + "dsn.notify", dsnNotify);
            }
            if ((dsnRet = this.configuration.getDSNRet()) != null) {
                this.props.setProperty(protocolPrefix + "dsn.ret", dsnRet);
            }
            if ((allow8BitMime = this.configuration.getAllow8BitMime()) != null) {
                this.props.setProperty(protocolPrefix + "allow8bitmime", allow8BitMime.toString());
            }
            if ((sendPartial = this.configuration.getSendPartial()) != null) {
                this.props.setProperty(protocolPrefix + "sendpartial", sendPartial.toString());
            }
            if ((saslEnable = this.configuration.getSASLEnable()) != null) {
                this.props.setProperty(protocolPrefix + "sasl.enable", saslEnable.toString());
            }
            if ((saslMechanisms = this.configuration.getSASLMechanisms()) != null) {
                this.props.setProperty(protocolPrefix + "sasl.mechanisms", saslMechanisms);
            }
            if ((saslAuthorizationId = this.configuration.getSASLAuthorizationId()) != null) {
                this.props.setProperty(protocolPrefix + "sasl.authorizationid", saslAuthorizationId);
            }
            if ((saslRealm = this.configuration.getSASLRealm()) != null) {
                this.props.setProperty(protocolPrefix + "sasl.realm", saslRealm);
            }
            if ((saslUseCanonicalHostName = this.configuration.getSASLUseCanonicalHostName()) != null) {
                this.props.setProperty(protocolPrefix + "sasl.usecanonicalhostname", saslUseCanonicalHostName.toString());
            }
            if ((quitWait = this.configuration.getQuitWait()) != null) {
                this.props.setProperty(protocolPrefix + "quitwait", quitWait.toString());
            }
            if ((reportSuccess = this.configuration.getReportSuccess()) != null) {
                this.props.setProperty(protocolPrefix + "reportsuccess", reportSuccess.toString());
            }
            if ((socketFactoryClass = this.configuration.getSocketFactoryClass()) != null) {
                this.props.setProperty(protocolPrefix + "socketFactory.class", socketFactoryClass);
            }
            if ((socketFactoryFallback = this.configuration.getSocketFactoryFallback()) != null) {
                this.props.setProperty(protocolPrefix + "socketFactory.fallback", socketFactoryFallback.toString());
            }
            if ((socketFactoryPort = this.configuration.getSocketFactoryPort()) != null) {
                this.props.setProperty(protocolPrefix + "socketFactory.port", socketFactoryPort.toString());
            }
            if ((sslCheckServerIdentity = this.configuration.getSSLCheckServerIdentity()) != null) {
                this.props.setProperty(protocolPrefix + "ssl.checkserveridentity", sslCheckServerIdentity.toString());
            }
            if ((sslTrust = this.configuration.getSSLTrust()) != null) {
                this.props.setProperty(protocolPrefix + "ssl.trust", sslTrust);
            }
            if ((sslSocketFactoryClass = this.configuration.getSSLSocketFactoryClass()) != null) {
                this.props.setProperty(protocolPrefix + "ssl.socketFactory.class", sslSocketFactoryClass);
            }
            if ((sslSocketFactoryPort = this.configuration.getSSLSocketFactoryPort()) != null) {
                this.props.setProperty(protocolPrefix + "ssl.socketFactory.port", sslSocketFactoryPort.toString());
            }
            if ((sslProtocols = this.configuration.getSSLProtocols()) != null) {
                this.props.setProperty(protocolPrefix + "ssl.protocols", sslProtocols);
            }
            if ((sslCipherSuites = this.configuration.getSSLCipherSuites()) != null) {
                this.props.setProperty(protocolPrefix + "ssl.ciphersuites", sslCipherSuites);
            }
            if ((startTLSEnable = this.configuration.getStartTLSEnable()) != null) {
                this.props.setProperty(protocolPrefix + "starttls.enable", startTLSEnable.toString());
            }
            if ((startTLSRequired = this.configuration.getStartTLSRequired()) != null) {
                this.props.setProperty(protocolPrefix + "starttls.required", startTLSRequired.toString());
            }
            if ((socksHost = this.configuration.getSocksHost()) != null) {
                this.props.setProperty(protocolPrefix + "socks.host", socksHost);
            }
            if ((socksPort = this.configuration.getSocksPort()) != null) {
                this.props.setProperty(protocolPrefix + "socks.port", socksPort);
            }
            if ((mailExtension = this.configuration.getMailExtension()) != null) {
                this.props.setProperty(protocolPrefix + "mailextension", mailExtension);
            }
            if ((userSet = this.configuration.getUserSet()) != null) {
                this.props.setProperty(protocolPrefix + "userset", userSet.toString());
            }
            if ((noOpStrict = this.configuration.getNoOpStrict()) != null) {
                this.props.setProperty(protocolPrefix + "noop.strict", noOpStrict.toString());
            }
            Enumeration<?> enumerator = this.props.propertyNames();
            while (enumerator.hasMoreElements()) {
                String prop = (String)enumerator.nextElement();
                LOG.info("{} = {}", (Object)prop, (Object)this.props.getProperty(prop));
            }
        }
    }

    public void setConfiguration(DictionaryAdapterBasedConfigurationImpl configuration) {
        this.configuration = configuration;
        this.reconfigure();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    @ObjectClassDefinition(name="Mailer", description="The mailer is used to integrate javax.mail and a templating mechanism into the OSGI container.")
    public static @interface OSGIConfiguration {
        @AttributeDefinition(name="Debug", description="Set this property to true, to enable debug messages.")
        public boolean debug() default false;

        @AttributeDefinition(name="Host", description="The mail server hostname")
        public String host();

        @AttributeDefinition(name="Port", description="The mail server port")
        public int port();

        @AttributeDefinition(name="User", description="The username to use for the mail server login")
        public String user();

        @AttributeDefinition(name="Password", description="The password to use for the mail server login", type=AttributeType.PASSWORD)
        public String password();

        @AttributeDefinition(name="Sender address", description="The email address to use as the mail sender")
        public String senderAddress();

        @AttributeDefinition(name="Connection timeout", description="The timeout in milliseconds for establishing a connection. Defaults to infinity.")
        public int connectionTimeout();

        @AttributeDefinition(name="Read timeout", description="The timeout in milliseconds for reading from a connection. Defaults to infinity.")
        public int readTimeout();

        @AttributeDefinition(name="Write timeout", description="The timeout in milliseconds for writing to a connection. Defaults to infinity.")
        public int writeTimeout();

        @AttributeDefinition(name="From", description="Set the mail envelope return address. Defaults to message.getFrom().")
        public String from();

        @AttributeDefinition(name="Localhost", description="Override the name of the local host for the HELO/EHLO command.")
        public String localhost();

        @AttributeDefinition(name="Local address", description="The address to which a local SMTP socket should be bound. Defaults to the value picked from the Socket class.")
        public String localAddress();

        @AttributeDefinition(name="Local port", description="The port to which a local SMTP socket should be bound. Defaults to the value picked from the Socket class.")
        public int localPort();

        @AttributeDefinition(name="Sign on with EHLO", description="Disable to sign in with HELO command.")
        public boolean ehlo() default true;

        @AttributeDefinition(name="Authenticate with AUTH", description="If this property is true, authentication with be done with the AUTH command.")
        public boolean auth() default false;

        @AttributeDefinition(name="Submitter", description="The submitter to use in the AUTH tag in the MAIL FROM command. Typically used by a mail relay to pass along information about the original submitter of the message.")
        public String submitter();

        @AttributeDefinition(name="NOTIFY option", description="The NOTIFY option to the RCPT command. Either NEVER, or some combination of SUCCESS, FAILURE, and DELAY (separated by commas).")
        public String dsnNotify();

        @AttributeDefinition(name="RET option", description="The RET option to the MAIL command. Either FULL or HDRS.")
        public String dsnRet();

        @AttributeDefinition(name="Allow 8Bit Mime", description="If set to true, 'quoted-printalbe' and 'base64' encodings will be converted to '8bit'. Please note, that this has to be supported by the server.")
        public boolean allow8BitMime();

        @AttributeDefinition(name="Send mails partially", description="If not all targeted mail addresses are valid, the mail would still be sent to the others.")
        public boolean sendPartial() default false;

        @AttributeDefinition(name="Use SASL for login", description="Use javax.security.sasl for the login authentication. Defaults to false")
        public boolean saslEnable();

        @AttributeDefinition(name="SASL mechanism names to use", description="A comma separated list of SASL mechanism names that should be tried out during authentication.")
        public String saslMechanisms();

        @AttributeDefinition(name="SASL authorization ID", description="An authorization ID to use in SASL. If not set the 'User' value would be used.")
        public String saslAuthorizationId();

        @AttributeDefinition(name="SASL Realm", description="Realm for Digest-MD5 authentication")
        public String saslRealm();

        @AttributeDefinition(name="SASL use canonical hostname for connection", description="If this property is true, InetAddress.getCanonicalHostName() will be used for SASL authentication rather than the 'Host' property.")
        public String saslUseCanonicalHostName();

        @AttributeDefinition(name="Wait for quit", description="Wait for a response of the QUIT command. If set to false, the connection will be closed immediately after QUIT command.")
        public boolean quitWait() default true;

        @AttributeDefinition(name="Report succes with exception", description="Throw an exception for every successfully sent mail addressee.")
        public boolean reportSuccess() default false;

        @AttributeDefinition(name="Socket factory class name", description="Class name of a custom javax.net.SocketFactory implementation.")
        public String socketFactoryClass();

        @AttributeDefinition(name="Socket factory fallback enabled", description="If the defined socket factory can not create a socket, a fallback will be used.")
        public boolean socketFactoryFallback() default true;

        @AttributeDefinition(name="Socket factory port", description="Specific connection target port, when the provided socket factory class is used.")
        public int socketFactoryPort();

        @AttributeDefinition(name="Enable SSL", description="If true, SSL will be used for connections")
        public boolean sslEnable() default false;

        @AttributeDefinition(name="Check SSL server identity", description="If true, the identity of the target server will be checked.")
        public boolean sslCheckServerIdentity() default false;

        @AttributeDefinition(name="Trust", description="If '*' is set, all hostnames are trusted. Provide a space separated list of hostnames to mark those as trusted. If no value is provided the trust will depend on the server certificates.")
        public String sslTrust();

        @AttributeDefinition(name="SSL Socket factory class name", description="Class name of a custom javax.net.ssl.SSLSocketFactory implementation")
        public String sslSocketFactoryClass();

        @AttributeDefinition(name="SSL Socket factory port", description="Specific connection target port, when the provided SSL socket factory class is used.")
        public int sslSocketFactoryPort();

        @AttributeDefinition(name="Allowed SSL protocols", description="Space separated list of enabled SSL protocols")
        public String sslProtocols();

        @AttributeDefinition(name="Allowed SSL cipher suites", description="Space separated list of enabled SSL cipher suites")
        public String sslCipherSuites();

        @AttributeDefinition(name="Enable switching to TLS", description="Set to true, to allow switching to TLS")
        public boolean startTlsEnable() default false;

        @AttributeDefinition(name="Require switching to TLS from server", description="Require switching to TLS during establishment of a connection")
        public boolean startTlsRequired() default false;

        @AttributeDefinition(name="SOCKS5 proxy host", description="The host name of a SOCKS5 proxy to use for connection creation.")
        public String socksHost();

        @AttributeDefinition(name="SOCKS5 proxy port", description="The port of a SOCKS5 proxy to use for connection creation.")
        public String socksPort();

        @AttributeDefinition(name="Extension for MAIL command", description="An extension string to append to the MAIL command")
        public String mailExtension();

        @AttributeDefinition(name="Test connection with RSET", description="If set to true, the connection status will be tested with RSET instead of NOOP command.")
        public boolean userSet() default false;

        @AttributeDefinition(name="Require 250 status for NOOP", description="Require a status reponse to the NOOP command.")
        public boolean noOpStrict() default true;

        @AttributeDefinition(name="Mail Impl Bundle", description="The symbolic name of the OSGI bundle, that implements the Mail API.")
        public String mailImplBundle() default "com.sun.mail.javax.mail";
    }
}

