/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class FloatStringConverter
extends AbstractPrimitiveStringConverter<Float> {
    public FloatStringConverter() {
        super(Float.class);
    }

    @Override
    public String convert(Float source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return Float.toString(source.floatValue());
    }

    @Override
    public Float reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return Float.valueOf(source);
        }
        catch (NumberFormatException e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

