/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class LongStringConverter
extends AbstractPrimitiveStringConverter<Long> {
    public LongStringConverter() {
        super(Long.class);
    }

    @Override
    public String convert(Long source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return Long.toString(source);
    }

    @Override
    public Long reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return Long.valueOf(source);
        }
        catch (NumberFormatException e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

