/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class BooleanStringConverter
extends AbstractPrimitiveStringConverter<Boolean> {
    public BooleanStringConverter() {
        super(Boolean.class);
    }

    @Override
    public String convert(Boolean source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return Boolean.toString(source);
    }

    @Override
    public Boolean reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return Boolean.valueOf(source);
        }
        catch (Exception e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

