/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class DateStringConverter
extends AbstractPrimitiveStringConverter<Date> {
    private SimpleDateFormat getSimpleDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    public DateStringConverter() {
        super(Date.class);
    }

    @Override
    public String convert(Date source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return this.getSimpleDateFormat().format(source);
    }

    @Override
    public Date reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            Date d = this.getSimpleDateFormat().parse(source);
            return d;
        }
        catch (ParseException ex) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

