/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import java.math.BigDecimal;
import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class BigDecimalStringConverter
extends AbstractPrimitiveStringConverter<BigDecimal> {
    public BigDecimalStringConverter() {
        super(BigDecimal.class);
    }

    @Override
    public String convert(BigDecimal source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return source.toPlainString();
    }

    @Override
    public BigDecimal reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return new BigDecimal(source);
        }
        catch (Exception e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

