/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.api.ConverterRegistry;
import org.bndly.common.converter.api.TwoWayConverter;
import org.bndly.common.converter.impl.BigDecimalStringConverter;
import org.bndly.common.converter.impl.BooleanStringConverter;
import org.bndly.common.converter.impl.ByteStringConverter;
import org.bndly.common.converter.impl.DateStringConverter;
import org.bndly.common.converter.impl.DoubleStringConverter;
import org.bndly.common.converter.impl.FloatStringConverter;
import org.bndly.common.converter.impl.IntegerStringConverter;
import org.bndly.common.converter.impl.LongStringConverter;
import org.bndly.common.converter.impl.ShortStringConverter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ConverterRegistry.class}, immediate=true)
public class ConverterRegistryImpl
implements ConverterRegistry {
    private final List<Converter> converters = new ArrayList<Converter>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindConverter", unbind="unbindConverter", service=Converter.class)
    protected void bindConverter(Converter converter) {
        this.addConverter(converter);
    }

    protected void unbindConverter(Converter converter) {
        this.removeConverter(converter);
    }

    @Activate
    public void init() {
        this.clear();
        this.addConverter(new NoOpConverter());
        this.addConverter(new BigDecimalStringConverter());
        this.addConverter(new BooleanStringConverter());
        this.addConverter(new ByteStringConverter());
        this.addConverter(new DateStringConverter());
        this.addConverter(new DoubleStringConverter());
        this.addConverter(new FloatStringConverter());
        this.addConverter(new IntegerStringConverter());
        this.addConverter(new LongStringConverter());
        this.addConverter(new ShortStringConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Converter getConverter(Class sourceType, Class targetType) {
        this.lock.readLock().lock();
        try {
            for (Converter converter : this.converters) {
                Converter c = converter.canConvertFromTo(sourceType, targetType);
                if (c == null && TwoWayConverter.class.isInstance(converter)) {
                    c = this.reverseConverter((TwoWayConverter)converter);
                    c = c.canConvertFromTo(sourceType, targetType);
                }
                if (c == null) continue;
                Converter converter2 = c;
                return converter2;
            }
            Iterator<Converter> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Converter reverseConverter(final TwoWayConverter converter) {
        return new Converter(){

            public Converter canConvertFromTo(Class sourceType, Class targetType) {
                if (converter.canConvertFromTo(targetType, sourceType) != null) {
                    return this;
                }
                return null;
            }

            public Object convert(Object source) throws ConversionException {
                return converter.reverseConvert(source);
            }
        };
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.converters.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void addConverter(Converter converter) {
        if (converter != null) {
            this.lock.writeLock().lock();
            try {
                this.converters.add(0, converter);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void removeConverter(Converter converter) {
        this.lock.writeLock().lock();
        try {
            Iterator<Converter> iterator = this.converters.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != converter) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private class NoOpConverter
    implements Converter {
        private NoOpConverter() {
        }

        public Converter canConvertFromTo(Class sourceType, Class targetType) {
            if (sourceType.equals(targetType)) {
                return this;
            }
            return null;
        }

        public Object convert(Object source) throws ConversionException {
            return source;
        }
    }
}

