/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class DoubleStringConverter
extends AbstractPrimitiveStringConverter<Double> {
    public DoubleStringConverter() {
        super(Double.class);
    }

    @Override
    public String convert(Double source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return Double.toString(source);
    }

    @Override
    public Double reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return Double.valueOf(source);
        }
        catch (NumberFormatException e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

