/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class IntegerStringConverter
extends AbstractPrimitiveStringConverter<Integer> {
    public IntegerStringConverter() {
        super(Integer.class);
    }

    @Override
    public String convert(Integer source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return Integer.toString(source);
    }

    @Override
    public Integer reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return Integer.valueOf(source);
        }
        catch (NumberFormatException e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

