/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class ShortStringConverter
extends AbstractPrimitiveStringConverter<Short> {
    public ShortStringConverter() {
        super(Short.class);
    }

    @Override
    public String convert(Short source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return Short.toString(source);
    }

    @Override
    public Short reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return Short.valueOf(source);
        }
        catch (NumberFormatException e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

