/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.converter.impl;

import org.bndly.common.converter.api.ConversionException;
import org.bndly.common.converter.api.Converter;
import org.bndly.common.converter.impl.AbstractPrimitiveStringConverter;
import org.osgi.service.component.annotations.Component;

@Component(service={Converter.class}, immediate=true)
public class ByteStringConverter
extends AbstractPrimitiveStringConverter<Byte> {
    public ByteStringConverter() {
        super(Byte.class);
    }

    @Override
    public String convert(Byte source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return Byte.toString(source);
    }

    @Override
    public Byte reverseConvert(String source) throws ConversionException {
        if (source == null) {
            return null;
        }
        try {
            return Byte.valueOf(source);
        }
        catch (NumberFormatException e) {
            throw new ConversionException(this.sourceType, source, "could not convert string to " + this.sourceType.getName());
        }
    }
}

