/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.bndly.common.html.Attribute;
import org.bndly.common.html.Content;
import org.bndly.common.html.ContentContainer;
import org.bndly.common.html.DefaultHandler;
import org.bndly.common.html.Entity;
import org.bndly.common.html.SelfClosingTag;
import org.bndly.common.html.Tag;
import org.bndly.common.html.Text;

public class ContentBuildingHandler
extends DefaultHandler {
    protected final List<Content> content = new ArrayList<Content>();
    protected final Stack<Tag> tagStack = new Stack();

    private Tag buildDefensiveCopy(Tag input) {
        ContentContainer parent = null;
        if (!this.tagStack.isEmpty()) {
            parent = this.tagStack.peek();
        }
        Tag t = new Tag(parent);
        t.setName(input.getName());
        List<Attribute> atts = input.getAttributes();
        if (atts != null) {
            for (Attribute attribute : atts) {
                t.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        return t;
    }

    @Override
    public void openedTag(Tag tag) {
        Tag defensiveCopy = this.buildDefensiveCopy(tag);
        this.appendToContent(defensiveCopy);
        this.tagStack.push(defensiveCopy);
    }

    @Override
    public void closedTag(Tag tag) {
        this.tagStack.pop();
    }

    @Override
    public void onSelfClosingTag(SelfClosingTag tag) {
        this.appendToContent(tag);
    }

    @Override
    public void onEntity(Entity entity) {
        this.appendToContent(entity);
    }

    @Override
    public void onText(Text text) {
        this.appendToContent(text);
    }

    private void appendToContent(Content c) {
        if (this.tagStack.isEmpty()) {
            this.content.add(c);
        } else {
            Tag p = this.tagStack.peek();
            List<Content> con = p.getContent();
            if (con == null) {
                con = new ArrayList<Content>();
                p.setContent(con);
            }
            con.add(c);
        }
    }

    public List<Content> getContent() {
        return this.content;
    }
}

