/*
 * Decompiled with CFR 0.152.
 */
package org.bndly.common.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.bndly.common.html.Attribute;
import org.bndly.common.html.Comment;
import org.bndly.common.html.Content;
import org.bndly.common.html.ContentContainer;
import org.bndly.common.html.DefaultHandler;
import org.bndly.common.html.DefaultParserConfig;
import org.bndly.common.html.Entity;
import org.bndly.common.html.HTML;
import org.bndly.common.html.HTML5EntityMap;
import org.bndly.common.html.HTMLParsingException;
import org.bndly.common.html.Handler;
import org.bndly.common.html.ParserConfig;
import org.bndly.common.html.PrettyPrintHandler;
import org.bndly.common.html.ProxyContent;
import org.bndly.common.html.SelfClosingTag;
import org.bndly.common.html.Tag;
import org.bndly.common.html.Text;

public final class Parser {
    private final List<Content> parsedContent = new ArrayList<Content>();
    private final Stack<ParsingState> states = new Stack();
    private final Reader reader;
    private final StringBuffer readContent = new StringBuffer();
    private final ParserConfig config;
    private long row;
    private long column;
    private Handler handler;

    public Parser(String inputString) {
        this(inputString, null);
    }

    public Parser(String inputString, ParserConfig config) {
        this(new StringReader(inputString), config);
    }

    public Parser(InputStream is) {
        this(is, (ParserConfig)null);
    }

    public Parser(InputStream is, ParserConfig config) {
        this(new InputStreamReader(is), config);
    }

    public Parser(InputStream is, String encoding) throws UnsupportedEncodingException {
        this(is, encoding, null);
    }

    public Parser(InputStream is, String encoding, ParserConfig config) throws UnsupportedEncodingException {
        this(new InputStreamReader(is, encoding), config);
    }

    public Parser(Reader reader) {
        this(reader, null);
    }

    public Parser(Reader reader, ParserConfig config) {
        if (config == null) {
            config = new DefaultParserConfig();
        }
        this.reader = reader;
        this.config = config;
    }

    public Parser handler(Handler handler) {
        this.handler = handler;
        return this;
    }

    public Parser parse() throws HTMLParsingException, IOException {
        int i;
        if (this.handler == null) {
            this.handler = DefaultHandler.NO_OP;
        }
        ContentContainer container = new ContentContainer(){

            @Override
            public List<Content> getContent() {
                return Parser.this.parsedContent;
            }

            @Override
            public ContentContainer getParent() {
                return null;
            }
        };
        this.states.push(new NewContentParsingState(container));
        while ((i = this.reader.read()) != -1) {
            char c = (char)i;
            if (c == '\n') {
                ++this.row;
                this.column = 0L;
            }
            this.readContent.append(c);
            this.peek().handleChar(c);
            ++this.column;
        }
        this.peek().eof();
        return this;
    }

    public List<Content> getContent() {
        return this.parsedContent;
    }

    public HTML getHTML() {
        return this.createHTMLFromContent(this.parsedContent);
    }

    private HTML createHTMLFromContent(final List<Content> content) {
        return new HTML(){

            @Override
            public HTML copy() {
                List copied = Parser.this._copy(content, null);
                return Parser.this.createHTMLFromContent(copied);
            }

            @Override
            public String toPlainString() {
                PrettyPrintHandler prettyPrintHandler = new PrettyPrintHandler().skipNewLines().skipIndent();
                for (Content content2 : this.getContent()) {
                    Parser.this.print(content2, prettyPrintHandler);
                }
                return prettyPrintHandler.getPrettyString();
            }

            @Override
            public List<Content> getContent() {
                return content;
            }

            @Override
            public ContentContainer getParent() {
                return null;
            }
        };
    }

    private void print(Content content, PrettyPrintHandler prettyPrintHandler) {
        if (Tag.class.isInstance(content)) {
            Tag sourceTag = (Tag)content;
            prettyPrintHandler.openedTag(sourceTag);
            if (sourceTag.getContent() != null) {
                for (Content nested : sourceTag.getContent()) {
                    this.print(nested, prettyPrintHandler);
                }
            }
            prettyPrintHandler.closedTag(sourceTag);
        } else if (SelfClosingTag.class.isInstance(content)) {
            SelfClosingTag sourceTag = (SelfClosingTag)content;
            prettyPrintHandler.onSelfClosingTag(sourceTag);
        } else if (Text.class.isInstance(content)) {
            Text sourceText = (Text)content;
            prettyPrintHandler.onText(sourceText);
        } else if (Entity.class.isInstance(content)) {
            Entity sourceEntity = (Entity)content;
            prettyPrintHandler.onEntity(sourceEntity);
        } else if (ProxyContent.class.isInstance(content)) {
            ProxyContent proxy = (ProxyContent)content;
            Content proxied = proxy.getContent();
            if (proxied != null) {
                this.print(proxied, prettyPrintHandler);
            }
        } else {
            throw new IllegalStateException("unsupported content: " + content);
        }
    }

    private Content _copy(Content content, ContentContainer parent) {
        if (Tag.class.isInstance(content)) {
            Tag sourceTag = (Tag)content;
            Tag tag = new Tag(parent);
            tag.setName(sourceTag.getName());
            List<Attribute> attribtues = sourceTag.getAttributes();
            if (attribtues != null) {
                for (Attribute attribtue : attribtues) {
                    tag.setAttribute(attribtue.getName(), attribtue.getValue());
                }
            }
            tag.setContent(this._copy(sourceTag.getContent(), (ContentContainer)tag));
            return tag;
        }
        if (SelfClosingTag.class.isInstance(content)) {
            SelfClosingTag sourceTag = (SelfClosingTag)content;
            SelfClosingTag selfClosingTag = new SelfClosingTag(parent);
            selfClosingTag.setName(sourceTag.getName());
            List<Attribute> attribtues = sourceTag.getAttributes();
            if (attribtues != null) {
                for (Attribute attribtue : attribtues) {
                    selfClosingTag.setAttribute(attribtue.getName(), attribtue.getValue());
                }
            }
            return selfClosingTag;
        }
        if (Text.class.isInstance(content)) {
            Text sourceText = (Text)content;
            Text text = new Text(parent);
            text.setValue(sourceText.getValue());
            return text;
        }
        if (Entity.class.isInstance(content)) {
            Entity sourceEntity = (Entity)content;
            Entity entity = new Entity(parent);
            entity.setName(sourceEntity.getName());
            return entity;
        }
        if (ProxyContent.class.isInstance(content)) {
            ProxyContent proxy = (ProxyContent)content;
            Content proxied = proxy.getContent();
            if (proxied != null) {
                return this._copy(proxied, parent);
            }
            return null;
        }
        throw new IllegalStateException("unsupported content: " + content);
    }

    private List<Content> _copy(List<Content> source, ContentContainer parent) {
        if (source == null) {
            return null;
        }
        ArrayList<Content> copyContent = new ArrayList<Content>();
        for (Content sourceContent : source) {
            Content copy = this._copy(sourceContent, parent);
            if (copy == null) continue;
            copyContent.add(copy);
        }
        return copyContent;
    }

    private ParsingState replay(String acceptedSoFar) throws HTMLParsingException {
        for (int i = 0; i < acceptedSoFar.length(); ++i) {
            this.peek().handleChar(acceptedSoFar.charAt(i));
        }
        return this.peek();
    }

    private <E extends ParsingState> E push(E state) {
        this.states.push(state);
        return state;
    }

    private ParsingState peek() {
        return this.states.peek();
    }

    private ParsingState pop() {
        return this.states.pop();
    }

    private HTMLParsingException createException(String message) {
        return this.createException(message, null);
    }

    private HTMLParsingException createException(Throwable cause) {
        return this.createException(null, cause);
    }

    private HTMLParsingException createException(String message, Throwable cause) {
        if (message != null && cause == null) {
            return new HTMLParsingException(this.row, this.column, message);
        }
        if (message == null && cause != null) {
            return new HTMLParsingException(this.row, this.column, cause);
        }
        if (message != null && cause != null) {
            return new HTMLParsingException(this.row, this.column, message, cause);
        }
        return new HTMLParsingException(this.row, this.column);
    }

    private TextParsingState createTextParsingState(final List<Content> content, ContentContainer parent) {
        return new TextParsingState(parent){

            @Override
            protected void onText(Text text) {
                content.add(text);
                Parser.this.handler.onText(text);
            }
        };
    }

    private EntityParsingState createEntityParsingState(final List<Content> content, ContentContainer parent) {
        return new EntityParsingState(parent){

            @Override
            protected void onEntity(Entity entity) throws HTMLParsingException {
                content.add(entity);
                Parser.this.handler.onEntity(entity);
            }
        };
    }

    private TagParsingState createTagParsingState(final List<Content> content, ContentContainer parent) {
        return new TagParsingState(parent){

            @Override
            protected void onSelfClosingTag(SelfClosingTag tag) {
                content.add(tag);
                Parser.this.handler.onSelfClosingTag(tag);
            }

            @Override
            protected void onTagOpened(Tag tag) {
                content.add(tag);
                Parser.this.handler.openedTag(tag);
            }

            @Override
            protected void onTagClosed(Tag tag) {
                Parser.this.pop();
                Parser.this.handler.closedTag(tag);
            }

            @Override
            protected void onComment(Comment comment) {
                if (Parser.this.config.isCommentParsingEnabled()) {
                    content.add(comment);
                }
            }
        };
    }

    private abstract class BufferUntilTokenParsingState
    implements ParsingState {
        private final String endToken;
        private final StringBuffer buffer = new StringBuffer();
        final List<Matcher> matchers = new ArrayList<Matcher>();

        public BufferUntilTokenParsingState(String endToken) {
            if (endToken == null || endToken.isEmpty()) {
                throw new IllegalArgumentException("endtoken has to have at least one char");
            }
            this.endToken = endToken;
        }

        public final StringBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void handleChar(char c) throws HTMLParsingException {
            if (this.endToken.charAt(0) == c) {
                this.matchers.add(new Matcher(this.endToken));
            }
            Iterator<Matcher> iterator = this.matchers.iterator();
            while (iterator.hasNext()) {
                Matcher next = iterator.next();
                next.match(c);
                if (next.didMatch()) {
                    Parser.this.pop();
                    String buffered = this.buffer.substring(0, this.buffer.length() - (this.endToken.length() - 1));
                    this.onEndTokenFound(buffered);
                    return;
                }
                if (!next.didNotMatch()) continue;
                iterator.remove();
            }
            this.buffer.append(c);
        }

        protected abstract void onEndTokenFound(String var1);
    }

    private static class Matcher {
        private final String expected;
        private boolean didMatch;
        private boolean didNotMatch;
        private int pos = 0;

        public Matcher(String expected) {
            this.expected = expected;
        }

        public final void match(char c) {
            if (this.pos >= this.expected.length()) {
                return;
            }
            if (this.expected.charAt(this.pos) == c) {
                ++this.pos;
                if (this.pos == this.expected.length()) {
                    this.didMatch = true;
                }
            } else {
                this.didNotMatch = true;
            }
        }

        protected boolean didMatch() {
            return this.didMatch;
        }

        protected boolean didNotMatch() {
            return this.didNotMatch;
        }
    }

    private abstract class AttributeParsingState
    implements ParsingState {
        StringBuffer attributeNameBuf = new StringBuffer();
        boolean nameHasStarted = false;
        boolean nameHasCompleted = false;

        private AttributeParsingState() {
        }

        @Override
        public void handleChar(char c) throws HTMLParsingException {
            if (c == '=') {
                if (!this.nameHasStarted) {
                    throw Parser.this.createException("attribute name of a tag is not allowed to start with =");
                }
                this.nameHasCompleted = true;
                Parser.this.pop();
                this.onAttributeWithValue(this.attributeNameBuf.toString());
            } else if (Parser.this.config.isWhiteSpace(c)) {
                if (!this.nameHasStarted) {
                    throw Parser.this.createException("attribute of a tag had no name");
                }
                this.nameHasCompleted = true;
                Parser.this.pop();
                this.onAttributeWithoutValue(this.attributeNameBuf.toString(), Character.valueOf(c));
            } else if ('>' == c) {
                if (!this.nameHasStarted) {
                    throw Parser.this.createException("closing an attribute without a name");
                }
                Parser.this.pop();
                this.onAttributeWithoutValue(this.attributeNameBuf.toString(), Character.valueOf(c));
            } else if (!this.nameHasCompleted) {
                if ('/' == c) {
                    if (!this.nameHasStarted) {
                        throw Parser.this.createException("attribute without a name");
                    }
                    this.nameHasCompleted = true;
                    Parser.this.pop();
                    this.onAttributeWithoutValue(this.attributeNameBuf.toString(), Character.valueOf(c));
                } else {
                    if (!Parser.this.config.isAllowedAttributeNameCharacter(c)) {
                        throw Parser.this.createException("unallowed character '" + c + "' for attribute name");
                    }
                    this.nameHasStarted = true;
                    this.attributeNameBuf.append(c);
                }
            } else {
                throw Parser.this.createException("name of attribute '" + this.attributeNameBuf.toString() + "' has been parsed already.");
            }
        }

        protected abstract void onAttributeWithValue(String var1) throws HTMLParsingException;

        protected abstract void onAttributeWithoutValue(String var1, Character var2) throws HTMLParsingException;

        @Override
        public void eof() throws HTMLParsingException {
            if (Parser.this.config.isUnbalancedTagTolerated()) {
                Parser.this.pop();
                if (this.nameHasStarted) {
                    this.onAttributeWithoutValue(this.attributeNameBuf.toString(), null);
                }
            } else {
                throw Parser.this.createException("attribute of tag was not parsed completely");
            }
            Parser.this.peek().eof();
        }
    }

    private abstract class BufferStringParsingState
    implements ParsingState {
        private final boolean stopOnWhiteSpace;
        private final String excludedChars;
        private final StringBuffer buffer = new StringBuffer();

        public BufferStringParsingState(boolean stopOnWhiteSpace, String excludedChars) {
            this.excludedChars = excludedChars;
            this.stopOnWhiteSpace = stopOnWhiteSpace;
        }

        @Override
        public final void handleChar(char c) throws HTMLParsingException {
            if (this.excludedChars.indexOf(c) >= 0 || this.stopOnWhiteSpace && Parser.this.config.isWhiteSpace(c)) {
                this.onBufferComplete(this.buffer, c);
            } else {
                this.buffer.append(c);
            }
        }

        protected StringBuffer getBuffer() {
            return this.buffer;
        }

        protected abstract void onBufferComplete(StringBuffer var1, char var2) throws HTMLParsingException;
    }

    private abstract class ConsumeWhiteSpaceParsingState
    implements ParsingState {
        private ConsumeWhiteSpaceParsingState() {
        }

        @Override
        public final void handleChar(char c) throws HTMLParsingException {
            if (!Parser.this.config.isWhiteSpace(c)) {
                this.onNonWhiteSpace(c);
            }
        }

        protected abstract void onNonWhiteSpace(char var1) throws HTMLParsingException;
    }

    private abstract class AcceptStringParsingState
    implements ParsingState {
        private final String toAccept;
        private final boolean autoLowerCaseChars;
        private int pos;

        public AcceptStringParsingState(String toAccept, boolean autoLowerCaseChars) {
            this.toAccept = toAccept;
            this.autoLowerCaseChars = autoLowerCaseChars;
        }

        @Override
        public final void handleChar(char c) throws HTMLParsingException {
            if (this.autoLowerCaseChars) {
                c = Character.toLowerCase(c);
            }
            if (this.toAccept.charAt(this.pos) == c) {
                ++this.pos;
                if (this.pos == this.toAccept.length()) {
                    this.onAccepted();
                }
            } else {
                this.onNotAccepted(c);
            }
        }

        protected final String acceptedSoFar() {
            return this.toAccept.substring(0, this.pos);
        }

        protected abstract void onNotAccepted(char var1) throws HTMLParsingException;

        protected abstract void onAccepted() throws HTMLParsingException;
    }

    private abstract class AcceptCharacterParsingState
    implements ParsingState {
        private final char acceptedChar;

        public AcceptCharacterParsingState(char acceptedChar) {
            this.acceptedChar = acceptedChar;
        }

        @Override
        public final void handleChar(char c) throws HTMLParsingException {
            if (c != this.acceptedChar) {
                this.onDifferingChar(c);
            } else {
                this.onMatchedChar(c);
            }
        }

        protected abstract void onDifferingChar(char var1) throws HTMLParsingException;

        protected abstract void onMatchedChar(char var1) throws HTMLParsingException;
    }

    private abstract class AttributeListParsingState
    extends ConsumeWhiteSpaceParsingState {
        private final ContentContainer parent;
        private final String tagName;
        private final List<Attribute> attributes;

        public AttributeListParsingState(ContentContainer parent, String tagName, List<Attribute> attributes) {
            this.parent = parent;
            if (tagName == null) {
                throw new IllegalArgumentException("tagName is not allowed to be null");
            }
            this.tagName = tagName;
            if (attributes == null) {
                throw new IllegalArgumentException("attributes is not allowed to be null");
            }
            this.attributes = attributes;
        }

        private SelfClosingTag createSelfClosingTag() {
            SelfClosingTag selfClosingTag = new SelfClosingTag(this.parent);
            if (Parser.this.config.isAutomaticLowerCaseEnabled(this.tagName)) {
                selfClosingTag.setName(this.tagName.toLowerCase());
            } else {
                selfClosingTag.setName(this.tagName);
            }
            selfClosingTag.setAttributes(this.attributes);
            return selfClosingTag;
        }

        private Tag createTag() {
            Tag tag = new Tag(this.parent);
            tag.setAttributes(this.attributes);
            if (Parser.this.config.isAutomaticLowerCaseEnabled(this.tagName)) {
                tag.setName(this.tagName.toLowerCase());
            } else {
                tag.setName(this.tagName);
            }
            tag.setContent(new ArrayList<Content>());
            return tag;
        }

        protected abstract void onSelfClosingTag(SelfClosingTag var1);

        protected abstract void onTagOpened(Tag var1);

        @Override
        protected void onNonWhiteSpace(char c) throws HTMLParsingException {
            if ('/' == c) {
                Parser.this.pop();
                Parser.this.push(new AcceptCharacterParsingState('>'){

                    @Override
                    protected void onDifferingChar(char c) throws HTMLParsingException {
                        throw Parser.this.createException("self closing tag was not closed properly. tagName: " + AttributeListParsingState.this.tagName);
                    }

                    @Override
                    protected void onMatchedChar(char c) throws HTMLParsingException {
                        Parser.this.pop();
                        AttributeListParsingState.this.onSelfClosingTag(AttributeListParsingState.this.createSelfClosingTag());
                    }

                    @Override
                    public void eof() throws HTMLParsingException {
                        if (!Parser.this.config.isUnbalancedTagTolerated()) {
                            throw Parser.this.createException("self closing tag was not closed");
                        }
                        Parser.this.pop();
                        AttributeListParsingState.this.onSelfClosingTag(AttributeListParsingState.this.createSelfClosingTag());
                        Parser.this.peek().eof();
                    }
                });
            } else if ('>' == c) {
                Parser.this.pop();
                if (Parser.this.config.isSelfClosingTag(Parser.this.config.isAutomaticLowerCaseEnabled(this.tagName) ? this.tagName.toLowerCase() : this.tagName)) {
                    this.onSelfClosingTag(this.createSelfClosingTag());
                } else {
                    Tag tag = this.createTag();
                    this.onTagOpened(tag);
                    Parser.this.push(new ContentParsingState(tag, tag.getContent()));
                }
            } else {
                Parser.this.push(this.createAttributeParsingState()).handleChar(c);
            }
        }

        private ParsingState createAttributeParsingState() {
            return new AttributeParsingState(){

                @Override
                protected void onAttributeWithValue(final String attributeName) throws HTMLParsingException {
                    Parser.this.push(new ConsumeWhiteSpaceParsingState(){

                        @Override
                        protected void onNonWhiteSpace(char c) throws HTMLParsingException {
                            Parser.this.pop();
                            if (c == '\'' || c == '\"') {
                                final String closeChar = Character.toString(c);
                                Parser.this.push(new BufferStringParsingState(false, closeChar){

                                    @Override
                                    protected void onBufferComplete(StringBuffer buffer, char c) throws HTMLParsingException {
                                        Attribute attribute = new Attribute();
                                        attribute.setName(attributeName);
                                        attribute.setValue(buffer.toString());
                                        AttributeListParsingState.this.attributes.add(attribute);
                                        Parser.this.pop();
                                    }

                                    @Override
                                    public void eof() throws HTMLParsingException {
                                        if (!Parser.this.config.isUnbalancedTagTolerated()) {
                                            throw Parser.this.createException("attribute values was not terminated by " + closeChar);
                                        }
                                        Parser.this.pop();
                                        Attribute attribute = new Attribute();
                                        attribute.setName(attributeName);
                                        attribute.setValue(this.getBuffer().toString());
                                        AttributeListParsingState.this.attributes.add(attribute);
                                        Parser.this.peek().eof();
                                    }
                                });
                            } else if (Parser.this.config.isUnquotedAttributeValueTolerated()) {
                                (Parser.this.push(new BufferStringParsingState(true, ">"){

                                    @Override
                                    protected void onBufferComplete(StringBuffer buffer, char c) throws HTMLParsingException {
                                        Attribute attribute = new Attribute();
                                        attribute.setName(attributeName);
                                        if (buffer.charAt(buffer.length() - 1) == '/') {
                                            String value = buffer.substring(0, buffer.length() - 1);
                                            attribute.setValue(value);
                                        } else {
                                            attribute.setValue(buffer.toString());
                                        }
                                        AttributeListParsingState.this.attributes.add(attribute);
                                        Parser.this.pop();
                                        Parser.this.peek().handleChar(c);
                                    }

                                    @Override
                                    public void eof() throws HTMLParsingException {
                                        if (!Parser.this.config.isUnbalancedTagTolerated()) {
                                            throw Parser.this.createException("attribute value was incomplete");
                                        }
                                        Parser.this.pop();
                                        Attribute attribute = new Attribute();
                                        attribute.setName(attributeName);
                                        attribute.setValue(this.getBuffer().toString());
                                        AttributeListParsingState.this.attributes.add(attribute);
                                        Parser.this.peek().eof();
                                    }
                                })).handleChar(c);
                            } else {
                                throw Parser.this.createException("attribute values need to be wrapped in ' or \" characters");
                            }
                        }

                        @Override
                        public void eof() throws HTMLParsingException {
                            if (!Parser.this.config.isUnbalancedTagTolerated()) {
                                throw Parser.this.createException("value of attribute could not be parsed");
                            }
                            Parser.this.pop();
                            Attribute attribute = new Attribute();
                            attribute.setName(attributeName);
                            AttributeListParsingState.this.attributes.add(attribute);
                            Parser.this.peek().eof();
                        }
                    });
                }

                @Override
                protected void onAttributeWithoutValue(String attributeName, Character c) throws HTMLParsingException {
                    Attribute attribute = new Attribute();
                    attribute.setName(attributeName);
                    AttributeListParsingState.this.attributes.add(attribute);
                    if (c != null) {
                        Parser.this.peek().handleChar(c.charValue());
                    }
                }
            };
        }

        @Override
        public void eof() throws HTMLParsingException {
            if (!Parser.this.config.isUnbalancedTagTolerated()) {
                throw Parser.this.createException("tag was not closed");
            }
            Parser.this.pop();
            this.onSelfClosingTag(this.createSelfClosingTag());
            Parser.this.peek().eof();
        }
    }

    private abstract class CloseTagParsingState
    extends AcceptStringParsingState {
        private final Tag parentTag;

        public CloseTagParsingState(Tag parentTag) {
            super(parentTag.getName(), Parser.this.config.isAutomaticLowerCaseEnabled(parentTag.getName()));
            this.parentTag = parentTag;
        }

        @Override
        protected final void onAccepted() {
            Parser.this.pop();
            Parser.this.push(new ConsumeWhiteSpaceParsingState(){

                @Override
                protected void onNonWhiteSpace(char c) throws HTMLParsingException {
                    if (c != '>') {
                        throw Parser.this.createException("tag " + CloseTagParsingState.this.parentTag.getName() + " was not closed properly");
                    }
                    Parser.this.pop();
                    CloseTagParsingState.this.onTagClosed(CloseTagParsingState.this.parentTag);
                }

                @Override
                public void eof() throws HTMLParsingException {
                    if (!Parser.this.config.isUnbalancedTagTolerated()) {
                        throw Parser.this.createException("tag " + CloseTagParsingState.this.parentTag.getName() + " was not closed properly");
                    }
                    Parser.this.pop();
                    CloseTagParsingState.this.onTagClosed(CloseTagParsingState.this.parentTag);
                    Parser.this.peek().eof();
                }
            });
        }

        @Override
        protected final void onNotAccepted(char c) throws HTMLParsingException {
            if (!Parser.this.config.isUnbalancedTagTolerated()) {
                throw Parser.this.createException("tag " + this.parentTag.getName() + " was not closed");
            }
            Parser.this.pop();
            this.onTagClosed(this.parentTag);
            Parser.this.replay("</" + this.acceptedSoFar()).handleChar(c);
        }

        @Override
        public final void eof() throws HTMLParsingException {
            if (!Parser.this.config.isUnbalancedTagTolerated()) {
                throw Parser.this.createException("tag " + this.parentTag.getName() + " was not closed");
            }
            Parser.this.pop();
            this.onTagClosed(this.parentTag);
            Parser.this.peek().eof();
        }

        protected abstract void onTagClosed(Tag var1);
    }

    private abstract class TagParsingState
    extends TagDetectionParsingState {
        private final ContentContainer parent;
        private TagParsingState that;

        public TagParsingState(ContentContainer parent) {
            this.parent = parent;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void onClosingTag() throws HTMLParsingException {
            this.that = this;
            if (!Tag.class.isInstance(this.parent)) {
                if (!Parser.this.config.isUnbalancedTagTolerated()) throw Parser.this.createException("there is no tag to be closed");
                Parser.this.push(new ParsingState(){

                    @Override
                    public void handleChar(char c) throws HTMLParsingException {
                        if (c == '>') {
                            Parser.this.pop();
                        }
                    }

                    @Override
                    public void eof() throws HTMLParsingException {
                        Parser.this.pop();
                        Parser.this.peek().eof();
                    }
                });
                return;
            } else {
                Parser.this.push(new CloseTagParsingState((Tag)this.parent){

                    @Override
                    protected void onTagClosed(Tag tag) {
                        TagParsingState.this.that.onTagClosed(tag);
                    }
                });
            }
        }

        @Override
        protected void onOpeningTag(String tagName, Character c) throws HTMLParsingException {
            final TagParsingState that = this;
            Parser.this.push(new AttributeListParsingState(this.parent, tagName, new ArrayList()){

                @Override
                protected void onSelfClosingTag(SelfClosingTag selfClosingTag) {
                    that.onSelfClosingTag(selfClosingTag);
                }

                @Override
                protected void onTagOpened(Tag tag) {
                    that.onTagOpened(tag);
                }
            });
            if (c != null) {
                Parser.this.peek().handleChar(c.charValue());
            }
        }

        @Override
        protected void onCommentStarted(char c) throws HTMLParsingException {
            final TagParsingState _this = this;
            (Parser.this.push(new CommentParsingState(this.parent){

                @Override
                protected void onComment(Comment comment) {
                    _this.onComment(comment);
                }
            })).handleChar(c);
        }

        @Override
        public void eof() throws HTMLParsingException {
            if (!Parser.this.config.isUnbalancedTagTolerated()) {
                throw Parser.this.createException("tag was not balanced");
            }
            Parser.this.pop();
            Parser.this.peek().eof();
        }

        protected abstract void onSelfClosingTag(SelfClosingTag var1);

        protected abstract void onTagOpened(Tag var1);

        protected abstract void onTagClosed(Tag var1);

        protected abstract void onComment(Comment var1);
    }

    private abstract class TagDetectionParsingState
    implements ParsingState {
        private TagDetectionParsingState() {
        }

        @Override
        public void handleChar(char c) throws HTMLParsingException {
            if ('<' == c) {
                Parser.this.pop();
                Parser.this.push(new BufferStringParsingState(true, "!/>"){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    protected void onBufferComplete(StringBuffer buffer, char c) throws HTMLParsingException {
                        Parser.this.pop();
                        String tagName = buffer.toString();
                        if (tagName.length() == 0) {
                            if ('/' == c) {
                                TagDetectionParsingState.this.onClosingTag();
                                return;
                            } else {
                                if ('!' != c) throw Parser.this.createException("tag name was empty");
                                TagDetectionParsingState.this.onCommentStarted(c);
                            }
                            return;
                        } else {
                            TagDetectionParsingState.this.onOpeningTag(tagName, Character.valueOf(c));
                        }
                    }

                    @Override
                    public void eof() throws HTMLParsingException {
                        if (Parser.this.config.isUnbalancedTagTolerated()) {
                            Parser.this.pop();
                            String tagName = this.getBuffer().toString();
                            if (!tagName.isEmpty()) {
                                TagDetectionParsingState.this.onOpeningTag(tagName, null);
                            }
                        } else {
                            throw Parser.this.createException("tag was not closed properly");
                        }
                        Parser.this.peek().eof();
                    }
                });
            } else if (Parser.this.config.isUnbalancedTagTolerated()) {
                Parser.this.pop();
                Parser.this.peek().eof();
            } else {
                throw Parser.this.createException("tags need to start with <");
            }
        }

        protected abstract void onCommentStarted(char var1) throws HTMLParsingException;

        protected abstract void onClosingTag() throws HTMLParsingException;

        protected abstract void onOpeningTag(String var1, Character var2) throws HTMLParsingException;
    }

    private abstract class EntityParsingState
    implements ParsingState {
        StringBuffer entityNameBuf = new StringBuffer();
        private final Entity entity;

        public EntityParsingState(ContentContainer parent) {
            this.entity = new Entity(parent);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleChar(char c) throws HTMLParsingException {
            if (c == ';') {
                Parser.this.pop();
                this.entity.setName(this.entityNameBuf.toString());
                this.onEntity(this.entity);
                return;
            } else if (Parser.this.config.isWhiteSpace(c)) {
                if (!Parser.this.config.isIncompleteEntityTolerated()) throw Parser.this.createException("HTML entities shall not contain white spaces");
                this.handleIncompleteEntity();
                Parser.this.peek().handleChar(c);
                return;
            } else {
                this.entityNameBuf.append(c);
            }
        }

        private void handleIncompleteEntity() throws HTMLParsingException {
            if (this.entityNameBuf.length() == 0) {
                Parser.this.pop();
                this.entity.setName(HTML5EntityMap.INSTANCE.getEntityName('&'));
                this.onEntity(this.entity);
            } else {
                Parser.this.pop();
                this.entity.setName(this.entityNameBuf.toString());
                this.onEntity(this.entity);
            }
        }

        @Override
        public void eof() throws HTMLParsingException {
            if (!Parser.this.config.isIncompleteEntityTolerated()) {
                throw Parser.this.createException("failed to parse HTML entity. reached EOF but missed ';' character.");
            }
            this.handleIncompleteEntity();
            Parser.this.peek().eof();
        }

        protected abstract void onEntity(Entity var1) throws HTMLParsingException;
    }

    private abstract class CommentParsingState
    extends AcceptStringParsingState {
        private final Comment comment;

        public CommentParsingState(ContentContainer parent) {
            super("!--", false);
            this.comment = new Comment(parent);
        }

        @Override
        protected void onNotAccepted(char c) throws HTMLParsingException {
            throw Parser.this.createException("comment was not started properly");
        }

        @Override
        protected void onAccepted() throws HTMLParsingException {
            Parser.this.pop();
            Parser.this.push(new BufferUntilTokenParsingState("-->"){

                @Override
                protected void onEndTokenFound(String buffered) {
                    CommentParsingState.this.comment.setValue(buffered);
                    CommentParsingState.this.onComment(CommentParsingState.this.comment);
                }

                @Override
                public void eof() throws HTMLParsingException {
                    if (!Parser.this.config.isUnbalancedTagTolerated()) {
                        throw Parser.this.createException("comment was not closed properly");
                    }
                    Parser.this.pop();
                    CommentParsingState.this.comment.setValue(this.getBuffer().toString());
                    CommentParsingState.this.onComment(CommentParsingState.this.comment);
                    Parser.this.peek().eof();
                }
            });
        }

        @Override
        public final void eof() throws HTMLParsingException {
            if (!Parser.this.config.isUnbalancedTagTolerated()) {
                throw Parser.this.createException("comment was not closed properly");
            }
            Parser.this.pop();
            this.onComment(this.comment);
            Parser.this.peek().eof();
        }

        protected abstract void onComment(Comment var1);
    }

    private abstract class TextParsingState
    implements ParsingState {
        StringBuffer textBuf = new StringBuffer();
        private final Text text;

        public TextParsingState(ContentContainer parent) {
            this.text = new Text(parent);
        }

        @Override
        public void handleChar(char c) throws HTMLParsingException {
            if (c == '<' || c == '&') {
                this.text.setValue(this.textBuf.toString());
                this.onText(this.text);
                Parser.this.pop();
                Parser.this.peek().handleChar(c);
            } else {
                if (Parser.this.config.isCharacterWithRequiredHtmlEntityInText(c)) {
                    String entity = HTML5EntityMap.INSTANCE.getEntity(c);
                    if (entity != null && '>' == c && Parser.this.config.isIncompleteEntityTolerated()) {
                        if (this.textBuf.length() > 0) {
                            this.text.setValue(this.textBuf.toString());
                            this.onText(this.text);
                        }
                        Parser.this.pop();
                        Parser.this.replay(entity);
                    } else {
                        throw Parser.this.createException("character '" + c + "' was not escaped as an entity");
                    }
                }
                this.textBuf.append(c);
            }
        }

        @Override
        public void eof() throws HTMLParsingException {
            this.text.setValue(this.textBuf.toString());
            this.onText(this.text);
            Parser.this.pop();
            Parser.this.peek().eof();
        }

        protected abstract void onText(Text var1);
    }

    private class ContentParsingState
    implements ParsingState {
        private final List<Content> content;
        private final ContentContainer parent;

        public ContentParsingState(ContentContainer parent) {
            this(parent, new ArrayList<Content>());
        }

        public ContentParsingState(ContentContainer parent, List<Content> content) {
            this.content = content;
            this.parent = parent;
        }

        @Override
        public void handleChar(char c) throws HTMLParsingException {
            if (c == '<') {
                ((TagParsingState)Parser.this.push(Parser.this.createTagParsingState(this.content, this.parent))).handleChar(c);
            } else if (c == '&') {
                Parser.this.push(Parser.this.createEntityParsingState(this.content, this.parent));
            } else {
                ((TextParsingState)Parser.this.push(Parser.this.createTextParsingState(this.content, this.parent))).handleChar(c);
            }
        }

        @Override
        public void eof() throws HTMLParsingException {
            if (Tag.class.isInstance(this.parent)) {
                if (Parser.this.config.isUnbalancedTagTolerated()) {
                    Parser.this.handler.closedTag((Tag)this.parent);
                } else {
                    throw Parser.this.createException("tag " + ((Tag)this.parent).getName() + " was not closed");
                }
            }
            Parser.this.pop();
            Parser.this.peek().eof();
        }

        public List<Content> getContent() {
            return this.content;
        }
    }

    private class NewContentParsingState
    extends ContentParsingState {
        public NewContentParsingState(ContentContainer parent) {
            super(parent, Parser.this.parsedContent);
        }

        @Override
        public void eof() throws HTMLParsingException {
        }
    }

    private static interface ParsingState {
        public void handleChar(char var1) throws HTMLParsingException;

        public void eof() throws HTMLParsingException;
    }
}

